/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.web;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import ren.crux.web.RestWebProperties;
import ren.crux.web.interceptor.AnnotationInterceptorRegistrationConfigurer;

@Configuration
@EnableConfigurationProperties
@ComponentScan(basePackages={"ren.crux.web.interceptor"})
public class RestWebAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RestWebProperties restWebProperties() {
        return new RestWebProperties();
    }

    @Bean
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
        return builder -> builder.serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance).serializerByType(Long.TYPE, (JsonSerializer)ToStringSerializer.instance).serializerByType(Double.class, (JsonSerializer)ToStringSerializer.instance).serializerByType(Double.TYPE, (JsonSerializer)ToStringSerializer.instance).modules(new Module[]{new GuavaModule()}).timeZone("GMT+8");
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public WebMvcConfigurer webMvcConfigurer(ApplicationContext context) {
        return new AnnotationInterceptorRegistrationConfigurer(context);
    }
}

