/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.web.common;

import org.springframework.http.HttpStatus;
import ren.crux.web.common.RestWebResultContainer;

public class RestWebResults {
    private static int DEFAULT_FAIL_CODE = -1;
    private static int DEFAULT_SUCC_CODE = 0;
    private static String DEFAULT_SUCC_MSG = "ok";
    private static String DEFAULT_FAIL_MSG = "fail";

    private RestWebResults() {
    }

    public static RestWebResultContainer succeed(int code, String msg, Object data) {
        return new RestWebResultContainer(code, msg, data);
    }

    public static RestWebResultContainer succeed(String msg, Object data) {
        return RestWebResults.succeed(DEFAULT_SUCC_CODE, msg, data);
    }

    public static RestWebResultContainer succeed(Object data) {
        return RestWebResults.succeed(DEFAULT_SUCC_MSG, data);
    }

    public static RestWebResultContainer succeed() {
        return RestWebResults.succeed(null);
    }

    public static RestWebResultContainer fail(int code, String msg, Object data) {
        return new RestWebResultContainer(code, msg, data);
    }

    public static RestWebResultContainer fail(int code, String msg) {
        return RestWebResults.fail(code, msg, null);
    }

    public static RestWebResultContainer fail(HttpStatus status, String msg, Object data) {
        return new RestWebResultContainer(status.value(), msg, data);
    }

    public static RestWebResultContainer fail(HttpStatus status, String msg) {
        return new RestWebResultContainer(status.value(), msg);
    }

    public static RestWebResultContainer fail(HttpStatus status, Throwable e) {
        return RestWebResults.fail(status.value(), e);
    }

    public static RestWebResultContainer fail(int code, Throwable e) {
        return RestWebResults.fail(code, e.getMessage());
    }

    public static RestWebResultContainer fail(Throwable e) {
        return RestWebResults.fail(DEFAULT_FAIL_CODE, e);
    }

    public static RestWebResultContainer fail(String msg) {
        return RestWebResults.fail(DEFAULT_FAIL_CODE, msg, null);
    }

    public static RestWebResultContainer fail() {
        return RestWebResults.fail(DEFAULT_FAIL_MSG);
    }

    public static RestWebResultContainer operation(boolean result) {
        return result ? RestWebResults.succeed() : RestWebResults.fail();
    }

    public static int getDefaultFailCode() {
        return DEFAULT_FAIL_CODE;
    }

    public static void setDefaultFailCode(int defaultFailCode) {
        DEFAULT_FAIL_CODE = defaultFailCode;
    }

    public static int getDefaultSuccCode() {
        return DEFAULT_SUCC_CODE;
    }

    public static void setDefaultSuccCode(int defaultSuccCode) {
        DEFAULT_SUCC_CODE = defaultSuccCode;
    }

    public static String getDefaultSuccMsg() {
        return DEFAULT_SUCC_MSG;
    }

    public static void setDefaultSuccMsg(String defaultSuccMsg) {
        DEFAULT_SUCC_MSG = defaultSuccMsg;
    }

    public static String getDefaultFailMsg() {
        return DEFAULT_FAIL_MSG;
    }

    public static void setDefaultFailMsg(String defaultFailMsg) {
        DEFAULT_FAIL_MSG = defaultFailMsg;
    }
}

