/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.web.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import ren.crux.web.interceptor.InterceptException;

public abstract class AbstractAnnotationHandlerInterceptorAdapter<T extends Annotation>
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractAnnotationHandlerInterceptorAdapter.class);
    private static final String ANNOTATION_ATTRIBUTE_NAME = "__Annotation";
    private static final String ANNOTATION_CLASS_ATTRIBUTE_NAME = "__AnnotationClass";
    private final List<HttpMessageConverter<Object>> converters;

    protected AbstractAnnotationHandlerInterceptorAdapter(List<HttpMessageConverter<Object>> converters) {
        this.converters = converters;
    }

    protected abstract Class<T> getRequiredAnnotationClass();

    protected boolean matchRequiredAnnotation(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.trace("Check required annotation start ...");
        if (this.getRequiredAnnotationClass() != null && handler.getClass().isAssignableFrom(HandlerMethod.class)) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, this.getRequiredAnnotationClass());
            if (annotation == null) {
                annotation = AnnotationUtils.findAnnotation(method.getDeclaringClass(), this.getRequiredAnnotationClass());
            }
            if (annotation != null) {
                request.setAttribute(ANNOTATION_ATTRIBUTE_NAME, (Object)annotation);
                request.setAttribute(ANNOTATION_CLASS_ATTRIBUTE_NAME, this.getRequiredAnnotationClass());
                log.trace("Match required annotation : {}", (Object)annotation);
                return true;
            }
        }
        return false;
    }

    protected Object before(HttpServletRequest request, HttpServletResponse response, Object handler, T anno) throws Exception {
        return true;
    }

    protected void after(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView, T anno) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Object result;
        if (this.matchRequiredAnnotation(request, response, handler) && (result = this.before(request, response, handler, (Annotation)request.getAttribute(ANNOTATION_ATTRIBUTE_NAME))) != Boolean.TRUE) {
            throw new InterceptException(result);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (this.getRequiredAnnotationClass() != null && this.getRequiredAnnotationClass() == request.getAttribute(ANNOTATION_CLASS_ATTRIBUTE_NAME)) {
            this.after(request, response, handler, modelAndView, (Annotation)request.getAttribute(ANNOTATION_ATTRIBUTE_NAME));
            request.removeAttribute(ANNOTATION_ATTRIBUTE_NAME);
            request.removeAttribute(ANNOTATION_CLASS_ATTRIBUTE_NAME);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        super.afterConcurrentHandlingStarted(request, response, handler);
    }
}

