/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.web.interceptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import ren.crux.web.common.RestWebResultContainer;
import ren.crux.web.common.RestWebResults;

@RestControllerAdvice
@ConditionalOnProperty(prefix="rest", name={"enable-response-advice"}, havingValue="true", matchIfMissing=true)
public class RestResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(RestResponseBodyAdvice.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        log.debug("body : {}", body);
        if (body instanceof RestWebResultContainer) {
            return body;
        }
        return RestWebResults.succeed(body);
    }
}

