/*
 *
 *    Copyright 2018 The Crux Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package ren.crux.web.util;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

/**
 * @author wangzhihui
 */
public class NetWorkHelper {

    public static final String UNKNOWN = "unknown";
    public static final String[] HEADERS = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    public static final List<String> LOCATION_IP = Arrays.asList("127.0.0.1", "0:0:0:0:0:0:0:1");

    private static boolean isValidIp(String ip) {
        return StringUtils.isNotBlank(ip) && !StringUtils.equalsAnyIgnoreCase(ip, UNKNOWN);
    }

    public static String getClientIp(HttpServletRequest httpservletrequest) {
        String ip = null;
        for (String filed : HEADERS) {
            ip = httpservletrequest.getHeader(filed);
            if (isValidIp(ip)) {
                break;
            }
        }
        String[] ips = StringUtils.split(ip, ",");
        ip = ips == null ? null : ips[0];

        if (!isValidIp(ip)) {
            ip = httpservletrequest.getRemoteAddr();
        }
        if (LOCATION_IP.contains(ip)) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            } catch (UnknownHostException ignored) {
            }
        }
        return ip;
    }
}
