/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.web.interceptor;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import ren.crux.web.interceptor.Interceptor;

public class AnnotationInterceptorRegistrationConfigurer
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationInterceptorRegistrationConfigurer.class);
    private final ApplicationContext context;

    public AnnotationInterceptorRegistrationConfigurer(ApplicationContext context) {
        this.context = context;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        Map beans = this.context.getBeansWithAnnotation(Interceptor.class);
        for (Object bean : beans.values()) {
            Class<?> cls = bean.getClass();
            Interceptor annotation = cls.getAnnotation(Interceptor.class);
            if (annotation == null) continue;
            log.trace("Catch annotation interceptor : {}", cls);
            if (!(bean instanceof HandlerInterceptor)) {
                log.warn("Invalid annotation interceptor : {},  Not implement org.springframework.web.servlet.HandlerInterceptor", cls);
                continue;
            }
            InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)bean);
            Order order = cls.getAnnotation(Order.class);
            if (order != null) {
                registration.order(order.value());
            }
            if (annotation.value().length > 0) {
                registration.addPathPatterns(annotation.value());
            }
            if (annotation.exclude().length > 0) {
                registration.excludePathPatterns(annotation.exclude());
            }
            log.debug("add annotation interceptor [ {} ], order : {}, includePatterns : {}, excludePatterns : {}", new Object[]{cls, order != null ? Integer.valueOf(order.value()) : "null", annotation.value(), annotation.exclude()});
        }
    }
}

