/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.web.interceptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.NoHandlerFoundException;
import ren.crux.web.RestWebProperties;
import ren.crux.web.common.RestWebResultContainer;
import ren.crux.web.common.RestWebResults;
import ren.crux.web.interceptor.InterceptException;

@RestControllerAdvice
@ConditionalOnProperty(prefix="rest", name={"enable-exception-handler"}, havingValue="true", matchIfMissing=true)
public class RestExceptionHandlerAdvice {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandlerAdvice.class);
    private final RestWebProperties restWebProperties;

    public RestExceptionHandlerAdvice(RestWebProperties restWebProperties) {
        this.restWebProperties = restWebProperties;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<RestWebResultContainer> httpRequestMethodNotSupported(HttpRequestMethodNotSupportedException exception, WebRequest request) {
        log.error("Request : {} catch exception : ", (Object)request, (Object)exception);
        return ResponseEntity.status((HttpStatus)(this.restWebProperties.isUseOriginalHttpStatus() ? HttpStatus.METHOD_NOT_ALLOWED : HttpStatus.OK)).body((Object)RestWebResults.fail(HttpStatus.METHOD_NOT_ALLOWED, exception.getMessage()));
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<RestWebResultContainer> noHandlerFoundException(NoHandlerFoundException exception, WebRequest request) {
        log.error("Request : {} catch exception : ", (Object)request, (Object)exception);
        return ResponseEntity.status((HttpStatus)(this.restWebProperties.isUseOriginalHttpStatus() ? HttpStatus.NOT_FOUND : HttpStatus.OK)).body((Object)RestWebResults.fail(HttpStatus.NOT_FOUND, exception.getMessage()));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<RestWebResultContainer> missingServletRequestParameterException(MissingServletRequestParameterException exception, WebRequest request) {
        log.error("Request : {} catch exception : ", (Object)request, (Object)exception);
        return ResponseEntity.status((HttpStatus)(this.restWebProperties.isUseOriginalHttpStatus() ? HttpStatus.BAD_REQUEST : HttpStatus.OK)).body((Object)RestWebResults.fail(HttpStatus.BAD_REQUEST, exception.getMessage()));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<RestWebResultContainer> httpMessageNotReadableException(HttpMessageNotReadableException exception, WebRequest request) {
        log.error("Request : {} catch exception : ", (Object)request, (Object)exception);
        return ResponseEntity.status((HttpStatus)(this.restWebProperties.isUseOriginalHttpStatus() ? HttpStatus.BAD_REQUEST : HttpStatus.OK)).body((Object)RestWebResults.fail(HttpStatus.BAD_REQUEST, exception.getMessage()));
    }

    @ExceptionHandler(value={InterceptException.class})
    public ResponseEntity<RestWebResultContainer> interceptException(InterceptException exception, WebRequest request) {
        log.error("Request : {} catch exception : ", (Object)request, (Object)exception);
        return ResponseEntity.status((HttpStatus)(this.restWebProperties.isUseOriginalHttpStatus() ? exception.getStatus() : HttpStatus.OK)).body((Object)(exception.getResult() instanceof RestWebResultContainer ? (RestWebResultContainer)exception.getResult() : RestWebResults.fail(exception.getStatus(), RestWebResults.getDefaultFailMsg(), exception.getResult())));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<RestWebResultContainer> exception(Exception exception, WebRequest request) {
        log.error("Request : {} catch exception : ", (Object)request, (Object)exception);
        return ResponseEntity.status((HttpStatus)(this.restWebProperties.isUseOriginalHttpStatus() ? HttpStatus.INTERNAL_SERVER_ERROR : HttpStatus.OK)).body((Object)RestWebResults.fail(HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)exception));
    }
}

