/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.web.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class CookiesHelper {
    public static String getValue(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.equals((CharSequence)cookie.getName(), (CharSequence)key)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void add(HttpServletResponse response, String key, String value) {
        CookiesHelper.add(response, key, value, -1, "/");
    }

    public static void add(HttpServletResponse response, String key, String value, String path) {
        CookiesHelper.add(response, key, value, -1, path);
    }

    public static void add(HttpServletResponse response, String key, String value, int second, String path) {
        Cookie cookie = new Cookie(key, value);
        cookie.setPath(path);
        cookie.setMaxAge(second);
        response.addCookie(cookie);
    }

    public static void add(HttpServletResponse response, String key, String value, int second, String path, String domain) {
        Cookie cookie = new Cookie(key, value);
        cookie.setPath(path);
        cookie.setMaxAge(second);
        cookie.setDomain(domain);
        response.addCookie(cookie);
    }

    public static void clear(HttpServletResponse response, String key, int second, String path) {
        Cookie cookie = new Cookie(key, null);
        cookie.setPath(path);
        cookie.setMaxAge(second);
        response.addCookie(cookie);
    }

    public static void clear(HttpServletResponse response, String key, int second, String path, String domain) {
        Cookie cookie = new Cookie(key, null);
        cookie.setPath(path);
        cookie.setMaxAge(second);
        cookie.setDomain(domain);
        response.addCookie(cookie);
    }
}

