/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.web.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class NetWorkHelper {
    public static final String UNKNOWN = "unknown";
    public static final String[] HEADERS = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    public static final List<String> LOCATION_IP = Arrays.asList("127.0.0.1", "0:0:0:0:0:0:0:1");

    private static boolean isValidIp(String ip) {
        return StringUtils.isNotBlank((CharSequence)ip) && !StringUtils.equalsAnyIgnoreCase((CharSequence)ip, (CharSequence[])new CharSequence[]{UNKNOWN});
    }

    public static String getClientIp(HttpServletRequest httpservletrequest) {
        String filed;
        String ip = null;
        String[] stringArray = HEADERS;
        int n = stringArray.length;
        for (int i = 0; i < n && !NetWorkHelper.isValidIp(ip = httpservletrequest.getHeader(filed = stringArray[i])); ++i) {
        }
        String[] ips = StringUtils.split(ip, (String)",");
        String string = ip = ips == null ? null : ips[0];
        if (!NetWorkHelper.isValidIp(ip)) {
            ip = httpservletrequest.getRemoteAddr();
        }
        if (LOCATION_IP.contains(ip)) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return ip;
    }
}

