/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ren.crux.jadb.Shell;
import ren.crux.jadb.base.AndroidDebugBridgeBase;
import ren.crux.jadb.model.Device;
import ren.crux.jadb.model.DeviceState;
import ren.crux.jadb.model.Target;
import ren.crux.jadb.util.OutputUtil;

public class AndroidDebugBridge {
    private static final Logger log = LoggerFactory.getLogger(AndroidDebugBridge.class);
    protected AndroidDebugBridgeBase base = new AndroidDebugBridgeBase();
    public Shell shell = new Shell(this.base);

    public List<Device> devices() throws Exception {
        ArrayList<Device> devices = new ArrayList<Device>();
        String output = this.base.devices();
        int index = (output = OutputUtil.requiredNonBlank(output)).indexOf("List of devices attached");
        if (index >= 0) {
            String body = output.substring(index + "List of devices attached".length());
            List<String> rows = OutputUtil.readLines(body);
            for (String row : rows) {
                log.debug("row : {}", (Object)row);
                String[] cells = StringUtils.split((String)row, (String)" ");
                if (cells.length < 2) continue;
                Device device = new Device();
                device.setSerialNumber(cells[0]);
                device.setEmulator(StringUtils.startsWith((CharSequence)cells[0], (CharSequence)"emulator-"));
                device.setState(DeviceState.valueOf(cells[1]));
                block15: for (int i = 1; i < cells.length; ++i) {
                    String cell = cells[i];
                    String[] pair = cell.split(":", 2);
                    if (pair.length != 2) continue;
                    switch (pair[0]) {
                        case "usb": {
                            device.setUsb(pair[1]);
                            continue block15;
                        }
                        case "product": {
                            device.setProduct(pair[1]);
                            continue block15;
                        }
                        case "model": {
                            device.setModel(pair[1]);
                            continue block15;
                        }
                        case "device": {
                            device.setDevice(pair[1]);
                            continue block15;
                        }
                        case "transport_id": {
                            if (!StringUtils.isNumeric((CharSequence)pair[1])) continue block15;
                            device.setTransportId(Integer.valueOf(pair[1]));
                            continue block15;
                        }
                    }
                }
                devices.add(device);
            }
        } else {
            throw new Exception("Invalid output : " + output);
        }
        return devices;
    }

    public boolean connect(String serialNumber) throws Exception {
        String output = this.base.connect(serialNumber);
        return (output = OutputUtil.requiredNonBlank(output)).equals("connected to " + serialNumber) || output.equals("already connected to " + serialNumber);
    }

    public boolean disconnect(String serialNumber) throws Exception {
        String output = this.base.disconnect(serialNumber);
        output = OutputUtil.requiredNonBlank(output);
        return output.equals("disconnected " + serialNumber);
    }

    public boolean install(Target target, String path, boolean grantAllPermissions, boolean replace) throws Exception {
        String output = this.base.install(target, path, grantAllPermissions, replace);
        output = OutputUtil.requiredNonBlank(output);
        return output.equals("Success");
    }

    public boolean install(String path, boolean grantAllPermissions, boolean replace) throws Exception {
        return this.install(null, path, grantAllPermissions, replace);
    }

    public boolean uninstall(Target target, String packageName, boolean keep) throws Exception {
        String output = this.base.uninstall(target, packageName, keep);
        output = OutputUtil.requiredNonBlank(output);
        return output.equals("Success");
    }

    public boolean uninstall(String packageName, boolean keep) throws Exception {
        return this.uninstall(null, packageName, keep);
    }

    public boolean tcpip(Target target, int port) throws Exception {
        String output = this.base.tcpip(target, port);
        output = OutputUtil.requiredNonBlank(output);
        return output.equals("restarting in TCP mode port: " + port);
    }

    public boolean tcpip(int port) throws Exception {
        return this.tcpip(null, port);
    }
}

