/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb.base;

import lombok.NonNull;
import org.apache.commons.exec.CommandLine;
import ren.crux.jadb.base.ShellBase;
import ren.crux.jadb.model.KeyEvent;
import ren.crux.jadb.model.Target;
import ren.crux.jadb.util.CommandLineTools;

public class InputBase {
    protected final ShellBase base;

    public InputBase(ShellBase base) {
        this.base = base;
    }

    protected CommandLine create(Target target) {
        return this.base.create(target).addArgument("input");
    }

    public String keyevent(Target target, @NonNull KeyEvent keyEvent) throws Exception {
        if (keyEvent == null) {
            throw new NullPointerException("keyEvent is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("keyevent").addArgument(keyEvent.toString());
        return CommandLineTools.exec(command);
    }

    public String keyevent(@NonNull KeyEvent keyEvent) throws Exception {
        if (keyEvent == null) {
            throw new NullPointerException("keyEvent is marked @NonNull but is null");
        }
        return this.keyevent(null, keyEvent);
    }

    public String text(Target target, @NonNull String content) throws Exception {
        if (content == null) {
            throw new NullPointerException("content is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("text").addArgument(content);
        return CommandLineTools.exec(command);
    }

    public String text(@NonNull String content) throws Exception {
        if (content == null) {
            throw new NullPointerException("content is marked @NonNull but is null");
        }
        return this.text(null, content);
    }

    public String tap(Target target, @NonNull String x, @NonNull String y) throws Exception {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("tap").addArgument(x).addArgument(y);
        return CommandLineTools.exec(command);
    }

    public String tap(@NonNull String x, @NonNull String y) throws Exception {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked @NonNull but is null");
        }
        return this.tap(null, x, y);
    }

    public String swipe(Target target, @NonNull String x1, @NonNull String y1, @NonNull String x2, @NonNull String y2) throws Exception {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked @NonNull but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked @NonNull but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked @NonNull but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("swipe").addArgument(x1).addArgument(y1).addArgument(x2).addArgument(y2);
        return CommandLineTools.exec(command);
    }

    public String swipe(@NonNull String x1, @NonNull String y1, @NonNull String x2, @NonNull String y2) throws Exception {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked @NonNull but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked @NonNull but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked @NonNull but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked @NonNull but is null");
        }
        return this.swipe(null, x1, y1, x2, y2);
    }
}

