/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import ren.crux.jadb.model.Flags;

public class Intent {
    private String action;
    private String dataUri;
    private String category;
    private String component;
    private Integer flagsValue;
    private String mimeType;
    private Map<String, Object> extras = new HashMap<String, Object>();
    private boolean selector = false;
    private List<Flags> flags = new ArrayList<Flags>();

    public Object putString(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return this.extras.put(key, value);
    }

    public Object putBool(@NonNull String key, boolean value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.extras.put(key, value);
    }

    public Object putInt(@NonNull String key, int value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.extras.put(key, value);
    }

    public Object putLong(@NonNull String key, long value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.extras.put(key, value);
    }

    public Object putFloat(@NonNull String key, float value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.extras.put(key, Float.valueOf(value));
    }

    public Object putIntArray(@NonNull String key, int[] value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.extras.put(key, value);
    }

    public Object putLongArray(@NonNull String key, long[] value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.extras.put(key, value);
    }

    public Object putFloatArray(@NonNull String key, float[] value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.extras.put(key, value);
    }

    public Object getExtra(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.extras.get(key);
    }

    public String getString(@NonNull String key, String def) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Object val = this.extras.getOrDefault(key, def);
        if (val instanceof String) {
            return (String)val;
        }
        return def;
    }

    public Boolean getBool(@NonNull String key, Boolean def) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Object val = this.extras.getOrDefault(key, def);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return def;
    }

    public String getInt(@NonNull String key, String def) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Object val = this.extras.getOrDefault(key, def);
        if (val instanceof String) {
            return (String)val;
        }
        return def;
    }

    public Long getLong(@NonNull String key, Long def) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Object val = this.extras.getOrDefault(key, def);
        if (val instanceof Long) {
            return (Long)val;
        }
        return def;
    }

    public Float getFloat(@NonNull String key, Float def) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Object val = this.extras.getOrDefault(key, def);
        if (val instanceof Float) {
            return (Float)val;
        }
        return def;
    }

    public int[] getIntArray(@NonNull String key, int[] def) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Object val = this.extras.getOrDefault(key, def);
        if (val instanceof int[]) {
            return (int[])val;
        }
        return def;
    }

    public long[] getLongArray(@NonNull String key, long[] def) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Object val = this.extras.getOrDefault(key, def);
        if (val instanceof long[]) {
            return (long[])val;
        }
        return def;
    }

    public float[] getFloatArray(@NonNull String key, float[] def) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Object val = this.extras.getOrDefault(key, def);
        if (val instanceof float[]) {
            return (float[])val;
        }
        return def;
    }

    public void addFlags(Flags ... flags) {
        if (flags != null) {
            this.flags.addAll(Arrays.asList(flags));
        }
    }

    public CommandLine write(CommandLine command) {
        this.valid2AddArgs(command, this.action, "-a");
        this.valid2AddArgs(command, this.dataUri, "-d");
        this.valid2AddArgs(command, this.category, "-c");
        this.valid2AddArgs(command, this.component, "-n");
        this.valid2AddArgs(command, this.mimeType, "-t");
        if (this.flagsValue != null) {
            command.addArgument("-f").addArgument(String.valueOf(this.flags));
        } else {
            this.flags.forEach(flag -> command.addArgument(flag.getArg()));
        }
        if (this.selector) {
            command.addArgument("--selector");
        }
        this.extras.forEach((key, value) -> {
            boolean valid = true;
            if (value instanceof String) {
                command.addArgument("--es");
            } else if (value instanceof Boolean) {
                command.addArgument("--ez");
            } else if (value instanceof Integer) {
                command.addArgument("--ei");
            } else if (value instanceof Long) {
                command.addArgument("--el");
            } else if (value instanceof Float) {
                command.addArgument("--ef");
            } else if (value instanceof int[]) {
                command.addArgument("--eia");
            } else if (value instanceof long[]) {
                command.addArgument("--ela");
            } else if (value instanceof float[]) {
                command.addArgument("--efa");
            } else {
                valid = false;
            }
            if (valid) {
                command.addArgument(key);
                if (value instanceof int[] || value instanceof long[] || value instanceof float[]) {
                    command.addArgument(StringUtils.join((Object[])new Object[]{",", value}));
                } else {
                    command.addArgument(String.valueOf(value));
                }
            }
        });
        return command;
    }

    private void valid2AddArgs(CommandLine command, String value, String arg) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            command.addArgument(arg).addArgument(value);
        }
    }

    public String getAction() {
        return this.action;
    }

    public String getDataUri() {
        return this.dataUri;
    }

    public String getCategory() {
        return this.category;
    }

    public String getComponent() {
        return this.component;
    }

    public Integer getFlagsValue() {
        return this.flagsValue;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public boolean isSelector() {
        return this.selector;
    }

    public List<Flags> getFlags() {
        return this.flags;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setDataUri(String dataUri) {
        this.dataUri = dataUri;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setFlagsValue(Integer flagsValue) {
        this.flagsValue = flagsValue;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setExtras(Map<String, Object> extras) {
        this.extras = extras;
    }

    public void setSelector(boolean selector) {
        this.selector = selector;
    }

    public void setFlags(List<Flags> flags) {
        this.flags = flags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Intent)) {
            return false;
        }
        Intent other = (Intent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$dataUri = this.getDataUri();
        String other$dataUri = other.getDataUri();
        if (this$dataUri == null ? other$dataUri != null : !this$dataUri.equals(other$dataUri)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$component = this.getComponent();
        String other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        Integer this$flagsValue = this.getFlagsValue();
        Integer other$flagsValue = other.getFlagsValue();
        if (this$flagsValue == null ? other$flagsValue != null : !((Object)this$flagsValue).equals(other$flagsValue)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        Map<String, Object> this$extras = this.getExtras();
        Map<String, Object> other$extras = other.getExtras();
        if (this$extras == null ? other$extras != null : !((Object)this$extras).equals(other$extras)) {
            return false;
        }
        if (this.isSelector() != other.isSelector()) {
            return false;
        }
        List<Flags> this$flags = this.getFlags();
        List<Flags> other$flags = other.getFlags();
        return !(this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Intent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $dataUri = this.getDataUri();
        result = result * 59 + ($dataUri == null ? 43 : $dataUri.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        Integer $flagsValue = this.getFlagsValue();
        result = result * 59 + ($flagsValue == null ? 43 : ((Object)$flagsValue).hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        Map<String, Object> $extras = this.getExtras();
        result = result * 59 + ($extras == null ? 43 : ((Object)$extras).hashCode());
        result = result * 59 + (this.isSelector() ? 79 : 97);
        List<Flags> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        return result;
    }

    public String toString() {
        return "Intent(action=" + this.getAction() + ", dataUri=" + this.getDataUri() + ", category=" + this.getCategory() + ", component=" + this.getComponent() + ", flagsValue=" + this.getFlagsValue() + ", mimeType=" + this.getMimeType() + ", extras=" + this.getExtras() + ", selector=" + this.isSelector() + ", flags=" + this.getFlags() + ")";
    }
}

