/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb.model;

import lombok.NonNull;
import ren.crux.jadb.model.TargetType;

public class Target {
    private final TargetType type;
    private final String serialNumber;

    public Target(TargetType type, String serialNumber) {
        this.type = type;
        this.serialNumber = serialNumber;
    }

    public static Target device() {
        return new Target(TargetType.device, "");
    }

    public static Target emulator() {
        return new Target(TargetType.emulator, "");
    }

    public static Target device(@NonNull String serialNumber) {
        if (serialNumber == null) {
            throw new NullPointerException("serialNumber is marked @NonNull but is null");
        }
        return new Target(TargetType.serial_number, serialNumber);
    }

    public TargetType getType() {
        return this.type;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Target)) {
            return false;
        }
        Target other = (Target)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TargetType this$type = this.getType();
        TargetType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        return !(this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Target;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TargetType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        return result;
    }

    public String toString() {
        return "Target(type=" + (Object)((Object)this.getType()) + ", serialNumber=" + this.getSerialNumber() + ")";
    }
}

