/*
 * Decompiled with CFR 0.152.
 */
package rocks.cleancode.conventionalcommit;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ConventionalCommit {
    private static final String EMPTY_STRING = "";
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final String DOUBLE_NEWLINE = NEWLINE + NEWLINE;
    private final String type;
    private final String scope;
    private final boolean exclamation;
    private final String description;
    private final String body;
    private final Map<String, String> footer;

    public ConventionalCommit(String type, String scope, boolean exclamation, String description, String body, Map<String, String> footer) {
        this.type = type;
        this.scope = scope;
        this.exclamation = exclamation;
        this.description = description;
        this.body = body;
        this.footer = footer;
    }

    public String type() {
        return this.type;
    }

    public Optional<String> scope() {
        return Optional.ofNullable(this.scope);
    }

    public boolean exclamation() {
        return this.exclamation;
    }

    public String description() {
        return this.description;
    }

    public Optional<String> body() {
        return Optional.ofNullable(this.body).filter(this::isNotBlank);
    }

    public Map<String, String> footer() {
        return this.footer;
    }

    private Predicate<String> isEmpty() {
        return String::isEmpty;
    }

    private boolean isNotBlank(String string) {
        return Optional.ofNullable(string).map(String::trim).filter(this.isEmpty().negate()).isPresent();
    }

    public boolean breakingChange() {
        return this.exclamation || this.footer.containsKey("BREAKING CHANGE");
    }

    public String toString() {
        return String.format("%s%s%s: %s%s%s", this.type, this.scopeToString(), this.exclamationToString(), this.description, this.bodyToString(), this.footerToString()).trim();
    }

    private String scopeToString() {
        return this.scope().map(this::surroundScope).orElse(EMPTY_STRING);
    }

    private String exclamationToString() {
        if (this.exclamation) {
            return "!";
        }
        return EMPTY_STRING;
    }

    private String bodyToString() {
        return this.body().map(DOUBLE_NEWLINE::concat).orElse(EMPTY_STRING);
    }

    private String footerToString() {
        return this.footer().entrySet().stream().map(this::joinFooterEntry).collect(Collectors.joining(NEWLINE, DOUBLE_NEWLINE, EMPTY_STRING));
    }

    private String joinFooterEntry(Map.Entry<String, String> entry) {
        return String.format("%s%s%s", entry.getKey(), ": ", entry.getValue());
    }

    private String surroundScope(String scope) {
        return String.format("(%s)", scope);
    }
}

