/*
 * Decompiled with CFR 0.152.
 */
package rocks.cleancode.conventionalcommit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class ConventionalCommitFooter {
    private static final String NEWLINE_REGEX = "\\r?\\n";
    private static final String KEY_REGEX = "(?:[^ :]+|BREAKING CHANGE)";
    private static final String FOOTER_SEPARATOR = ": ";
    private static final String FOOTER_REGEX = String.format("((?:%s){2}(%s%s.+(?:%s%s%s.+)*))$", "\\r?\\n", "(?:[^ :]+|BREAKING CHANGE)", ": ", "\\r?\\n", "(?:[^ :]+|BREAKING CHANGE)", ": ");
    private static final Pattern FOOTER_PATTERN = Pattern.compile(FOOTER_REGEX);
    private final String raw;
    private final Map<String, String> footer;

    ConventionalCommitFooter(String fullCommitMessage) {
        Matcher matcher = FOOTER_PATTERN.matcher(fullCommitMessage);
        if (matcher.find()) {
            this.raw = matcher.group(1);
            this.footer = this.parseFooters(matcher.group(2));
        } else {
            this.raw = "";
            this.footer = new HashMap<String, String>();
        }
    }

    public String raw() {
        return this.raw;
    }

    public Map<String, String> footer() {
        return this.footer;
    }

    private Map<String, String> parseFooters(String rawFooter) {
        String[] split = rawFooter.split(NEWLINE_REGEX);
        return Arrays.stream(split).map(this::parseFooter).collect(Collectors.toMap(array -> array[0], array -> array[1]));
    }

    private String[] parseFooter(String rawFooter) {
        int separatorIndex = rawFooter.indexOf(FOOTER_SEPARATOR);
        return new String[]{rawFooter.substring(0, separatorIndex), rawFooter.substring(separatorIndex + 2)};
    }
}

