/*
 * Decompiled with CFR 0.152.
 */
package rocks.cleancode.conventionalcommit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ConventionalCommitMessage {
    private static final String TYPE_REGEX = "(fix|feat|build|chore|ci|docs|style|refactor|perf|test)";
    private static final String SCOPE_REGEX = "(?:\\((.+)\\))";
    private static final String EXCLAMATION_REGEX = "(!)";
    private static final String DESCRIPTION_REGEX = "(.+)";
    private static final String CONVENTIONAL_COMMIT_REGEX = String.format("^(%s%s?%s?: %s)", "(fix|feat|build|chore|ci|docs|style|refactor|perf|test)", "(?:\\((.+)\\))", "(!)", "(.+)");
    private static final Pattern CONVENTIONAL_COMMIT_PATTERN = Pattern.compile(CONVENTIONAL_COMMIT_REGEX);
    private final String raw;
    private final String type;
    private final String scope;
    private final boolean exclamation;
    private final String description;

    ConventionalCommitMessage(String fullCommitMessage) {
        Matcher matcher = CONVENTIONAL_COMMIT_PATTERN.matcher(fullCommitMessage);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Malformed conventional commit message");
        }
        this.raw = matcher.group(1);
        this.type = matcher.group(2);
        this.scope = matcher.group(3);
        this.exclamation = matcher.group(4) != null;
        this.description = matcher.group(5);
    }

    public String raw() {
        return this.raw;
    }

    public String type() {
        return this.type;
    }

    public String scope() {
        return this.scope;
    }

    public boolean exclamation() {
        return this.exclamation;
    }

    public String description() {
        return this.description;
    }
}

