/*
 * Decompiled with CFR 0.152.
 */
package rocks.cleancode.conventionalcommit;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class ConventionalCommitMessage {
    private static final String SCOPE_REGEX = "(?:\\((.+)\\))";
    private static final String EXCLAMATION_REGEX = "(!)";
    private static final String DESCRIPTION_REGEX = "(.+)";
    private final String raw;
    private final String type;
    private final String scope;
    private final boolean exclamation;
    private final String description;

    ConventionalCommitMessage(List<String> types, String fullCommitMessage) {
        Pattern pattern = Pattern.compile(this.regex(types));
        Matcher matcher = pattern.matcher(fullCommitMessage);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Malformed conventional commit message");
        }
        this.raw = matcher.group(1);
        this.type = matcher.group(2);
        this.scope = matcher.group(3);
        this.exclamation = matcher.group(4) != null;
        this.description = matcher.group(5);
    }

    public String raw() {
        return this.raw;
    }

    public String type() {
        return this.type;
    }

    public String scope() {
        return this.scope;
    }

    public boolean exclamation() {
        return this.exclamation;
    }

    public String description() {
        return this.description;
    }

    private String regex(List<String> types) {
        return String.format("^(%s%s?%s?: %s)", this.typesRegex(types), SCOPE_REGEX, EXCLAMATION_REGEX, DESCRIPTION_REGEX);
    }

    private String typesRegex(List<String> types) {
        return types.stream().collect(Collectors.joining("|", "(", ")"));
    }
}

