/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure;

import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="coffeenet")
public class CoffeeNetConfigurationProperties {
    public static final String DEVELOPMENT = "development";
    public static final String INTEGRATION = "integration";
    @NotNull(message="Please choose the profile or mode in which your CoffeeNet application should start.")
    private Profile profile = Profile.DEVELOPMENT;
    @NotBlank(message="Please define the name of your application. This will be used in the navigation bar or for logging purposes e.g.")
    private String applicationName;
    @Deprecated
    private String allowedAuthorities;

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Deprecated
    public String getAllowedAuthorities() {
        return this.allowedAuthorities;
    }

    @Deprecated
    public void setAllowedAuthorities(String allowedAuthorities) {
        this.allowedAuthorities = allowedAuthorities;
    }

    public String toString() {
        return "CoffeeNetConfigurationProperties{profile=" + (Object)((Object)this.profile) + ", applicationName='" + this.applicationName + '\'' + ", allowedAuthorities='" + this.allowedAuthorities + '\'' + '}';
    }

    public static enum Profile {
        DEVELOPMENT,
        INTEGRATION;

    }
}

