/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.discovery.config;

import org.hibernate.validator.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import rocks.coffeenet.autoconfigure.CoffeeNetConfigurationProperties;

@Validated
@ConfigurationProperties(prefix="coffeenet.discovery.instance")
public class CoffeeNetDiscoveryInstanceProperties
extends EurekaInstanceConfigBean {
    @NotBlank(message="Please provide a hostname of your application.")
    private String hostname = "localhost";
    private CoffeeNetConfigurationProperties coffeeNetConfigurationProperties;

    CoffeeNetDiscoveryInstanceProperties(InetUtils inetUtils, CoffeeNetConfigurationProperties coffeeNetConfigurationProperties) {
        super(inetUtils);
        this.coffeeNetConfigurationProperties = coffeeNetConfigurationProperties;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setEnvironment(Environment environment) {
        String applicationName = this.coffeeNetConfigurationProperties.getApplicationName();
        if (StringUtils.hasText((String)applicationName)) {
            this.setAppname(applicationName);
            this.setVirtualHostName(applicationName);
            this.setSecureVirtualHostName(applicationName);
        }
    }

    public String toString() {
        return "CoffeeNetDiscoveryInstanceProperties{hostname='" + this.hostname + '\'' + ", coffeeNetConfigurationProperties=" + this.coffeeNetConfigurationProperties + '}';
    }
}

