/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.discovery.service;

import java.util.Set;
import java.util.TreeSet;

public class AppQuery {
    private final Set<String> appNames;
    private final Set<String> appRoles;

    private AppQuery(Builder builder) {
        this.appNames = builder.appNames;
        this.appRoles = builder.appRoles;
    }

    public Set<String> getAppNames() {
        return this.appNames;
    }

    public Set<String> getAppRoles() {
        return this.appRoles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<String> appNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        private final Set<String> appRoles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

        public AppQuery build() {
            return new AppQuery(this);
        }

        public Builder withAppName(String appName) {
            this.appNames.add(appName);
            return this;
        }

        public Builder withRole(String role) {
            this.appRoles.add(role);
            return this;
        }

        public Builder withRoles(Set<String> roles) {
            this.appRoles.addAll(roles);
            return this;
        }
    }
}

