/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.discovery.service;

import com.netflix.appinfo.InstanceInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClient;
import org.springframework.util.StringUtils;
import rocks.coffeenet.autoconfigure.discovery.service.AppQuery;
import rocks.coffeenet.autoconfigure.discovery.service.CoffeeNetApp;
import rocks.coffeenet.autoconfigure.discovery.service.CoffeeNetAppService;

public class IntegrationCoffeeNetAppService
implements CoffeeNetAppService {
    private DiscoveryClient discoveryClient;

    public IntegrationCoffeeNetAppService(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Override
    public Map<String, List<CoffeeNetApp>> getApps() {
        return this.getApps(AppQuery.builder().build());
    }

    @Override
    public Map<String, List<CoffeeNetApp>> getApps(AppQuery query) {
        Supplier<Map> map = () -> new TreeMap(String.CASE_INSENSITIVE_ORDER);
        return this.discoveryClient.getServices().stream().filter(appName -> query.getAppNames().isEmpty() || query.getAppNames().contains(appName)).map(appName -> this.getAppInstances((String)appName, query)).filter(coffeeNetApps -> !coffeeNetApps.isEmpty()).collect(Collectors.toMap(coffeeNetApps -> ((CoffeeNetApp)coffeeNetApps.get(0)).getName(), coffeeNetApps -> coffeeNetApps, (v1, v2) -> v1, map));
    }

    private List<CoffeeNetApp> getAppInstances(String appName, AppQuery query) {
        return this.discoveryClient.getInstances(appName).stream().map(IntegrationCoffeeNetAppService::toApp).filter(Objects::nonNull).filter(coffeeNetApp -> query.getAppRoles().isEmpty() || coffeeNetApp.isAllowedToAccessBy(query.getAppRoles())).collect(Collectors.toList());
    }

    private static CoffeeNetApp toApp(ServiceInstance serviceInstance) {
        if (!(serviceInstance instanceof EurekaDiscoveryClient.EurekaServiceInstance)) {
            return null;
        }
        EurekaDiscoveryClient.EurekaServiceInstance eurekaServiceInstance = (EurekaDiscoveryClient.EurekaServiceInstance)serviceInstance;
        InstanceInfo instanceInfo = eurekaServiceInstance.getInstanceInfo();
        Set<String> allowedAuthorities = StringUtils.commaDelimitedListToSet((String)((String)instanceInfo.getMetadata().get("allowedAuthorities"))).stream().map(String::trim).collect(Collectors.toSet());
        return new CoffeeNetApp(instanceInfo.getVIPAddress(), instanceInfo.getHomePageUrl(), allowedAuthorities);
    }
}

