/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.logging;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="coffeenet.logging.file")
public class CoffeeNetLoggingFileProperties {
    private static final int DEFAULT_HISTORY_30 = 30;
    private Boolean enabled;
    @NotBlank(message="Please provide a file where your logs will be written e.g. logs/app.log")
    private String file = "logs/app.log";
    @NotBlank(message="Please provide a file name pattern with a date pattern e.g. logs/app-%d{yyyy-MM-dd}.log")
    private String fileNamePattern = "logs/app-%d{yyyy-MM-dd}.log";
    @NotBlank(message="Please provide a log patter for your logs.")
    private String pattern = "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p --- [%t] %-40.40logger{39} : %m%n%wEx";
    @Min(value=1L, message="Only positive integers are allowed for the maximum amount of history files.")
    @NotNull(message="Please provide a maximum amount of history files you want to keep.")
    private int maxHistory = 30;

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public String toString() {
        return "CoffeeNetLoggingFileProperties{enabled=" + this.enabled + ", file='" + this.file + '\'' + ", fileNamePattern='" + this.fileNamePattern + '\'' + ", pattern='" + this.pattern + '\'' + ", maxHistory=" + this.maxHistory + '}';
    }
}

