/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.logging;

import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="coffeenet.logging.gelf")
public class CoffeeNetLoggingGelfProperties {
    private static final int DEFAULT_PORT = 12201;
    private Boolean enabled;
    @NotBlank(message="Please provide the server address of your graylog server.")
    private String server = "localhost";
    private String environment;
    @Min(value=1L, message="Please provide the port of your graylog server.")
    private int port = 12201;
    @NotBlank(message="Please provide the protocol of the communication with your graylog server.")
    private String protocol = "UDP";
    @NotBlank(message="Please provide the layout of the message which will be send to the graylog server.")
    private String layout = "%m %n";

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String toString() {
        return "CoffeeNetLoggingGelfProperties{enabled=" + this.enabled + ", server='" + this.server + '\'' + ", environment='" + this.environment + '\'' + ", port=" + this.port + ", protocol='" + this.protocol + '\'' + ", layout='" + this.layout + '\'' + '}';
    }
}

