/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.logging.config;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import de.appelgriepsch.logback.GelfAppender;
import javax.annotation.PostConstruct;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import rocks.coffeenet.autoconfigure.CoffeeNetConfigurationProperties;
import rocks.coffeenet.autoconfigure.logging.CoffeeNetLoggingConsoleProperties;
import rocks.coffeenet.autoconfigure.logging.CoffeeNetLoggingFileProperties;
import rocks.coffeenet.autoconfigure.logging.CoffeeNetLoggingGelfProperties;

@Configuration
@ConditionalOnClass(value={LoggerContext.class, GelfAppender.class})
@EnableConfigurationProperties(value={CoffeeNetLoggingFileProperties.class, CoffeeNetLoggingGelfProperties.class, CoffeeNetConfigurationProperties.class, CoffeeNetLoggingConsoleProperties.class})
@ConditionalOnProperty(prefix="coffeenet.logging", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CoffeeNetLoggingAutoConfiguration {
    private static final String CONSOLE = "CONSOLE";
    private static final String COFFEENET_FILE_APPENDER = "COFFEENET-FILE";
    private static final String COFFEENET_GELF = "COFFEENET-GELF";
    private static final LoggerContext LOGGER_CONTEXT = (LoggerContext)LoggerFactory.getILoggerFactory();
    private static final Logger LOGGER = LOGGER_CONTEXT.getLogger("ROOT");
    private final CoffeeNetLoggingConsoleProperties coffeeNetLoggingConsoleProperties;
    private final CoffeeNetLoggingFileProperties coffeeNetLoggingFileProperties;
    private final CoffeeNetLoggingGelfProperties coffeeNetLoggingGelfProperties;
    private final CoffeeNetConfigurationProperties coffeeNetConfigurationProperties;

    @Autowired
    public CoffeeNetLoggingAutoConfiguration(CoffeeNetLoggingFileProperties coffeeNetLoggingFileProperties, CoffeeNetLoggingGelfProperties coffeeNetLoggingGelfProperties, CoffeeNetConfigurationProperties coffeeNetConfigurationProperties, CoffeeNetLoggingConsoleProperties coffeeNetLoggingConsoleProperties) {
        this.coffeeNetLoggingFileProperties = coffeeNetLoggingFileProperties;
        this.coffeeNetLoggingGelfProperties = coffeeNetLoggingGelfProperties;
        this.coffeeNetConfigurationProperties = coffeeNetConfigurationProperties;
        this.coffeeNetLoggingConsoleProperties = coffeeNetLoggingConsoleProperties;
    }

    @PostConstruct
    public void configure() {
        if (this.disableConsoleAppender()) {
            LOGGER.detachAppender(CONSOLE);
        }
        if (this.enableFileAppender()) {
            LOGGER.addAppender(this.rollingFileAppender(LOGGER_CONTEXT));
        }
        if (this.enableGelfAppender()) {
            LOGGER.addAppender((Appender)this.gelfAppender(LOGGER_CONTEXT));
        }
    }

    private boolean disableConsoleAppender() {
        boolean disabled = this.coffeeNetLoggingConsoleProperties.isEnabled() == null ? "integration".equalsIgnoreCase(this.coffeeNetConfigurationProperties.getProfile().name()) : this.coffeeNetLoggingConsoleProperties.isEnabled() == false;
        return disabled;
    }

    private boolean enableGelfAppender() {
        boolean enabled = this.coffeeNetLoggingGelfProperties.isEnabled() == null ? "integration".equalsIgnoreCase(this.coffeeNetConfigurationProperties.getProfile().name()) : this.coffeeNetLoggingGelfProperties.isEnabled().booleanValue();
        return enabled;
    }

    private boolean enableFileAppender() {
        boolean enabled = this.coffeeNetLoggingFileProperties.isEnabled() == null ? "integration".equalsIgnoreCase(this.coffeeNetConfigurationProperties.getProfile().name()) : this.coffeeNetLoggingFileProperties.isEnabled().booleanValue();
        return enabled;
    }

    private GelfAppender gelfAppender(LoggerContext loggerContext) {
        GelfAppender gelfAppender = new GelfAppender();
        gelfAppender.setContext((Context)loggerContext);
        gelfAppender.setName(COFFEENET_GELF);
        gelfAppender.setServer(this.coffeeNetLoggingGelfProperties.getServer());
        gelfAppender.setProtocol(this.coffeeNetLoggingGelfProperties.getProtocol());
        gelfAppender.setPort(this.coffeeNetLoggingGelfProperties.getPort());
        gelfAppender.addAdditionalField("application", this.coffeeNetConfigurationProperties.getApplicationName());
        gelfAppender.addAdditionalField("environment", this.coffeeNetLoggingGelfProperties.getEnvironment());
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext((Context)loggerContext);
        patternLayout.setPattern(this.coffeeNetLoggingGelfProperties.getLayout());
        patternLayout.start();
        gelfAppender.setLayout((Layout)patternLayout);
        gelfAppender.start();
        return gelfAppender;
    }

    private RollingFileAppender<ILoggingEvent> rollingFileAppender(LoggerContext loggerContext) {
        RollingFileAppender rfAppender = new RollingFileAppender();
        rfAppender.setName(COFFEENET_FILE_APPENDER);
        rfAppender.setContext((Context)loggerContext);
        rfAppender.setFile(this.coffeeNetLoggingFileProperties.getFile());
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)loggerContext);
        rollingPolicy.setParent((FileAppender)rfAppender);
        rollingPolicy.setFileNamePattern(this.coffeeNetLoggingFileProperties.getFileNamePattern());
        rollingPolicy.setMaxHistory(this.coffeeNetLoggingFileProperties.getMaxHistory());
        rollingPolicy.start();
        rfAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern(this.coffeeNetLoggingFileProperties.getPattern());
        encoder.start();
        rfAppender.setEncoder((Encoder)encoder);
        rfAppender.start();
        return rfAppender;
    }
}

