/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.navigation;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.boot.info.BuildProperties;
import rocks.coffeenet.autoconfigure.discovery.service.AppQuery;
import rocks.coffeenet.autoconfigure.discovery.service.CoffeeNetApp;
import rocks.coffeenet.autoconfigure.discovery.service.CoffeeNetAppService;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationAppInformation;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationProperties;
import rocks.coffeenet.autoconfigure.navigation.CurrentCoffeeNetUser;
import rocks.coffeenet.autoconfigure.security.service.CoffeeNetCurrentUserService;
import rocks.coffeenet.autoconfigure.security.service.CoffeeNetUserDetails;

class CoffeeNetNavigationDataExtractor {
    private CoffeeNetNavigationProperties coffeeNetNavigationProperties;
    private Map<CoffeeNetServices, Object> services = new EnumMap<CoffeeNetServices, Object>(CoffeeNetServices.class);

    CoffeeNetNavigationDataExtractor(CoffeeNetNavigationProperties coffeeNetNavigationProperties) {
        this.coffeeNetNavigationProperties = coffeeNetNavigationProperties;
    }

    Optional<Map<String, List<CoffeeNetApp>>> extractApps() {
        Optional<CoffeeNetAppService> coffeeNetAppService = this.getCoffeeNetAppService();
        if (!coffeeNetAppService.isPresent()) {
            return Optional.empty();
        }
        HashMap<String, List<CoffeeNetApp>> preparedCoffeeNetApps = new HashMap<String, List<CoffeeNetApp>>();
        Optional<CoffeeNetCurrentUserService> userService = this.getCoffeeNetCurrentUserService();
        AppQuery.Builder queryBuilder = AppQuery.builder();
        userService.ifPresent(coffeeNetCurrentUserService -> coffeeNetCurrentUserService.get().ifPresent(userDetails -> queryBuilder.withRoles(userDetails.getAuthoritiesAsString())));
        Map<String, List<CoffeeNetApp>> filteredCoffeeNetApps = coffeeNetAppService.get().getApps(queryBuilder.build());
        String profileServiceName = this.coffeeNetNavigationProperties.getProfileServiceName();
        List<CoffeeNetApp> profileApps = filteredCoffeeNetApps.get(profileServiceName);
        if (profileApps != null) {
            CoffeeNetApp profileApp = profileApps.get(0);
            filteredCoffeeNetApps.remove(profileServiceName);
            preparedCoffeeNetApps.put("profile", Collections.singletonList(profileApp));
        }
        List firstCoffeeNetApps = filteredCoffeeNetApps.entrySet().stream().map(entry -> (CoffeeNetApp)((List)entry.getValue()).get(0)).sorted(Comparator.comparing(CoffeeNetApp::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        preparedCoffeeNetApps.put("apps", firstCoffeeNetApps);
        return Optional.of(preparedCoffeeNetApps);
    }

    Optional<CurrentCoffeeNetUser> extractUser() {
        Optional<CoffeeNetUserDetails> coffeeNetUserDetails;
        Optional<CurrentCoffeeNetUser> coffeeNetWebUser = Optional.empty();
        Optional<CoffeeNetCurrentUserService> userService = this.getCoffeeNetCurrentUserService();
        if (userService.isPresent() && (coffeeNetUserDetails = userService.get().get()).isPresent()) {
            String username = coffeeNetUserDetails.get().getUsername();
            String email = coffeeNetUserDetails.get().getEmail();
            coffeeNetWebUser = Optional.of(new CurrentCoffeeNetUser(username, email));
        }
        return coffeeNetWebUser;
    }

    String extractLogoutPath() {
        return this.coffeeNetNavigationProperties.getLogoutPath();
    }

    Optional<CoffeeNetNavigationAppInformation> extractAppInformation() {
        if (!this.getBuildProperties().isPresent()) {
            return Optional.empty();
        }
        String group = this.getBuildProperties().map(BuildProperties::getGroup).orElse("");
        String artifact = this.getBuildProperties().map(BuildProperties::getArtifact).orElse("");
        String version = this.getBuildProperties().map(BuildProperties::getVersion).orElse("");
        String parentGroup = this.getBuildProperties().get().get("parent.group");
        String parentArtifact = this.getBuildProperties().get().get("parent.artifact");
        String parentVersion = this.getBuildProperties().get().get("parent.version");
        return Optional.of(new CoffeeNetNavigationAppInformation(group, artifact, version, parentVersion, parentArtifact, parentGroup));
    }

    void registerService(CoffeeNetServices serviceName, Object service) {
        this.services.put(serviceName, service);
    }

    private Optional<CoffeeNetAppService> getCoffeeNetAppService() {
        Object service = this.services.get((Object)CoffeeNetServices.APP_SERVICE);
        if (service == null) {
            return Optional.empty();
        }
        return Optional.of((CoffeeNetAppService)service);
    }

    private Optional<CoffeeNetCurrentUserService> getCoffeeNetCurrentUserService() {
        Object service = this.services.get((Object)CoffeeNetServices.USER_SERVICE);
        if (service == null) {
            return Optional.empty();
        }
        return Optional.of((CoffeeNetCurrentUserService)service);
    }

    private Optional<BuildProperties> getBuildProperties() {
        Object properties = this.services.get((Object)CoffeeNetServices.BUILD_PROPERTIES);
        if (properties == null) {
            return Optional.empty();
        }
        return Optional.of((BuildProperties)properties);
    }

    public static enum CoffeeNetServices {
        APP_SERVICE,
        USER_SERVICE,
        BUILD_PROPERTIES;

    }
}

