/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.navigation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import rocks.coffeenet.autoconfigure.discovery.service.CoffeeNetApp;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationAppInformation;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationDataExtractor;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationInformation;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationService;
import rocks.coffeenet.autoconfigure.navigation.CurrentCoffeeNetUser;

public class CoffeeNetNavigationServiceImpl
implements CoffeeNetNavigationService {
    private final CoffeeNetNavigationDataExtractor dataExtractor;

    CoffeeNetNavigationServiceImpl(CoffeeNetNavigationDataExtractor dataExtractor) {
        this.dataExtractor = dataExtractor;
    }

    @Override
    public CoffeeNetNavigationInformation get() {
        CurrentCoffeeNetUser currentCoffeeNetUser = this.dataExtractor.extractUser().orElse(null);
        CoffeeNetNavigationAppInformation appInformation = this.dataExtractor.extractAppInformation().orElse(null);
        Map apps = this.dataExtractor.extractApps().orElseGet(Collections::emptyMap);
        String logoutPath = this.dataExtractor.extractLogoutPath();
        List profileApps = (List)apps.get("profile");
        CoffeeNetApp profileApp = null;
        if (profileApps != null && !profileApps.isEmpty()) {
            profileApp = (CoffeeNetApp)profileApps.get(0);
        }
        List coffeeNetApps = (List)apps.get("apps");
        return new CoffeeNetNavigationInformation(currentCoffeeNetUser, coffeeNetApps, profileApp, logoutPath, appInformation);
    }
}

