/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.navigation;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CurrentCoffeeNetUser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String username;
    private final String email;

    public CurrentCoffeeNetUser(String username, String email) {
        this.username = username;
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAvatar() {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] emailAsBytes = this.email.getBytes(StandardCharsets.UTF_8);
            String md5HashOfEmail = Hex.encodeHexString((byte[])md5.digest(emailAsBytes));
            return String.format("https://gravatar.com/avatar/%s?size=64", md5HashOfEmail);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.debug("/> Fallback to default avatar", (Throwable)e);
            return "/img/default_avatar.jpg";
        }
    }
}

