/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.config;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import rocks.coffeenet.autoconfigure.security.service.CoffeeNetUserDetails;
import rocks.coffeenet.autoconfigure.security.service.HumanCoffeeNetUser;
import rocks.coffeenet.autoconfigure.security.service.MachineCoffeeNetUser;

public class CoffeeNetPrincipalExtractor
implements PrincipalExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PRINCIPAL_NAME_KEY = "name";
    private static final String PRINCIPAL_KEY = "principal";
    private static final String USERNAME_KEY = "username";
    private static final String MAIL_KEY = "mail";
    private static final String UNKNOWN_VALUE = "UNKNOWN";
    private static final String ERROR_MSG_TEMPLATE = "Could not extract %s. Using default %s";
    private final AuthoritiesExtractor authoritiesExtractor;

    public CoffeeNetPrincipalExtractor(AuthoritiesExtractor authoritiesExtractor) {
        this.authoritiesExtractor = authoritiesExtractor;
    }

    public Object extractPrincipal(Map<String, Object> map) {
        if (((Boolean)map.getOrDefault("clientOnly", false)).booleanValue()) {
            return this.extractClientDetails(map);
        }
        return this.extractUserDetails(map);
    }

    private CoffeeNetUserDetails extractClientDetails(Map<String, Object> map) {
        if (map.containsKey(PRINCIPAL_NAME_KEY) && map.get(PRINCIPAL_NAME_KEY) instanceof String) {
            return new MachineCoffeeNetUser((String)map.get(PRINCIPAL_NAME_KEY), this.authoritiesExtractor.extractAuthorities(map));
        }
        LOGGER.warn(ERROR_MSG_TEMPLATE, (Object)PRINCIPAL_NAME_KEY, (Object)UNKNOWN_VALUE);
        return new MachineCoffeeNetUser(UNKNOWN_VALUE, this.authoritiesExtractor.extractAuthorities(map));
    }

    private CoffeeNetUserDetails extractUserDetails(Map<String, Object> map) {
        HumanCoffeeNetUser humanCoffeeUser;
        if (map.containsKey(PRINCIPAL_KEY) && map.get(PRINCIPAL_KEY) instanceof Map) {
            Map principal = (Map)map.get(PRINCIPAL_KEY);
            humanCoffeeUser = new HumanCoffeeNetUser(CoffeeNetPrincipalExtractor.extractUsername(principal), CoffeeNetPrincipalExtractor.extractMail(principal), this.authoritiesExtractor.extractAuthorities(map));
        } else {
            humanCoffeeUser = new HumanCoffeeNetUser(UNKNOWN_VALUE, UNKNOWN_VALUE, this.authoritiesExtractor.extractAuthorities(map));
            LOGGER.warn(ERROR_MSG_TEMPLATE, (Object)PRINCIPAL_KEY, (Object)humanCoffeeUser);
        }
        return humanCoffeeUser;
    }

    private static String extractUsername(Map principal) {
        String username;
        if (principal.containsKey(USERNAME_KEY) && principal.get(USERNAME_KEY) instanceof String) {
            username = (String)principal.get(USERNAME_KEY);
        } else {
            LOGGER.warn(ERROR_MSG_TEMPLATE, (Object)USERNAME_KEY, (Object)UNKNOWN_VALUE);
            username = UNKNOWN_VALUE;
        }
        return username;
    }

    private static String extractMail(Map principal) {
        String mail;
        if (principal.containsKey(MAIL_KEY) && principal.get(MAIL_KEY) instanceof String) {
            mail = (String)principal.get(MAIL_KEY);
        } else {
            LOGGER.warn(ERROR_MSG_TEMPLATE, (Object)MAIL_KEY, (Object)UNKNOWN_VALUE);
            mail = UNKNOWN_VALUE;
        }
        return mail;
    }
}

