/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetSecurityProperties;

@EnableConfigurationProperties(value={CoffeeNetSecurityProperties.class})
public class DevelopmentCoffeeNetWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    private CoffeeNetSecurityProperties securityConfigurationProperties;

    protected void configure(HttpSecurity http) throws Exception {
        String[] freeResources = new String[]{"/fonts/**", "/css/**", "/img/**", "/health", "/info"};
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(freeResources)).permitAll().anyRequest()).authenticated().and()).formLogin();
        if (this.securityConfigurationProperties.getDefaultLoginSuccessUrl() != null) {
            http.formLogin().defaultSuccessUrl(this.securityConfigurationProperties.getDefaultLoginSuccessUrl(), true);
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        ((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().withUser("admin").password("admin").roles(new String[]{"COFFEENET-ADMIN", "USER"}).and()).withUser("user").password("user").roles(new String[]{"USER"});
    }

    @Autowired
    public void setSecurityConfigurationProperties(CoffeeNetSecurityProperties securityConfigurationProperties) {
        this.securityConfigurationProperties = securityConfigurationProperties;
    }
}

