/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.service;

import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;
import rocks.coffeenet.autoconfigure.security.service.CoffeeNetUserDetails;

abstract class AbstractCoffeeNetUser
implements CoffeeNetUserDetails {
    AbstractCoffeeNetUser() {
    }

    @Override
    public boolean hasRoles(String ... roles) {
        for (String role : roles) {
            Assert.isTrue((!role.startsWith("ROLE_") ? 1 : 0) != 0, (String)(role + " cannot start with ROLE_ (it is automatically added)"));
            if (this.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_" + role))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> getAuthoritiesAsString() {
        return this.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
    }
}

