/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.service;

import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;
import rocks.coffeenet.autoconfigure.security.service.AbstractCoffeeNetUser;
import rocks.coffeenet.autoconfigure.security.service.UserDetailsInstance;

public final class HumanCoffeeNetUser
extends AbstractCoffeeNetUser {
    private final String email;
    private final UserDetailsInstance userDetailsInstance;

    public HumanCoffeeNetUser(String username, String email, Collection<GrantedAuthority> authorities) {
        Assert.notNull((Object)username, (String)"Please provide a username");
        Assert.notNull((Object)email, (String)"Please provide a email");
        Assert.notNull(authorities, (String)"Please provide authorities");
        this.email = email;
        this.userDetailsInstance = new UserDetailsInstance(username, authorities);
    }

    @Override
    public String getUsername() {
        return this.userDetailsInstance.getUsername();
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities() {
        return this.userDetailsInstance.getAuthorities();
    }

    @Override
    public boolean isCoffeeNetAdmin() {
        return this.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_COFFEENET-ADMIN"));
    }

    @Override
    public boolean isMachineUser() {
        return false;
    }

    public String toString() {
        return "HumanCoffeeNetUser{email='" + this.email + '\'' + ", userDetailsInstance=" + this.userDetailsInstance + '}';
    }
}

