/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.service;

import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;
import rocks.coffeenet.autoconfigure.security.service.AbstractCoffeeNetUser;
import rocks.coffeenet.autoconfigure.security.service.UserDetailsInstance;

public final class MachineCoffeeNetUser
extends AbstractCoffeeNetUser {
    private final UserDetailsInstance userDetailsInstance;

    public MachineCoffeeNetUser(String username, Collection<GrantedAuthority> authorities) {
        Assert.notNull((Object)username, (String)"Please provide a username");
        Assert.notNull(authorities, (String)"Please provide authorities");
        this.userDetailsInstance = new UserDetailsInstance(username, authorities);
    }

    @Override
    public String getUsername() {
        return this.userDetailsInstance.getUsername();
    }

    @Override
    public String getEmail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities() {
        return this.userDetailsInstance.getAuthorities();
    }

    @Override
    public boolean isCoffeeNetAdmin() {
        return false;
    }

    @Override
    public boolean isMachineUser() {
        return true;
    }

    public String toString() {
        return "MachineCoffeeNetUser{userDetailsInstance=" + this.userDetailsInstance + '}';
    }
}

