/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.actuate.autoconfigure;

import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.web.client.RestTemplate;
import rocks.coffeenet.actuate.AuthServerHealthIndicator;
import rocks.coffeenet.actuate.autoconfigure.AuthServerHealthIndicatorConfigurationProperties;

@Configuration
@ConditionalOnClass(value={OAuth2ClientContext.class, WebSecurityConfigurerAdapter.class})
@Conditional(value={OnSecurityAndIntegrationEnabled.class})
public class AuthServerHealthIndicatorConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"authServerHealthIndicator"})
    public HealthIndicator authServerHealthIndicator(AuthServerHealthIndicatorConfigurationProperties authServerHealthIndicatorConfigurationProperties) {
        return new AuthServerHealthIndicator(new RestTemplate(), authServerHealthIndicatorConfigurationProperties.getHealthUri());
    }

    @Bean
    public AuthServerHealthIndicatorConfigurationProperties authServerHealthIndicatorConfigurationProperties() {
        return new AuthServerHealthIndicatorConfigurationProperties();
    }

    static class OnSecurityAndIntegrationEnabled
    extends AllNestedConditions {
        OnSecurityAndIntegrationEnabled() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="coffeenet", name={"profile"}, havingValue="integration")
        static class OnIntegrationProfileEnabled {
            OnIntegrationProfileEnabled() {
            }
        }

        @ConditionalOnProperty(prefix="coffeenet.security", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class OnSecurityEnabled {
            OnSecurityEnabled() {
            }
        }
    }
}

