/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.discovery.config;

import com.netflix.discovery.EurekaClientConfig;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;
import rocks.coffeenet.autoconfigure.CoffeeNetConfigurationProperties;
import rocks.coffeenet.autoconfigure.discovery.config.CoffeeNetDiscoveryClientProperties;
import rocks.coffeenet.autoconfigure.discovery.config.CoffeeNetDiscoveryInstanceProperties;
import rocks.coffeenet.autoconfigure.discovery.config.CoffeeNetDiscoveryProperties;
import rocks.coffeenet.autoconfigure.discovery.service.CoffeeNetAppService;
import rocks.coffeenet.autoconfigure.discovery.service.DevelopmentCoffeeNetAppService;
import rocks.coffeenet.autoconfigure.discovery.service.IntegrationCoffeeNetAppService;

@Configuration
@AutoConfigureBefore(value={EurekaClientAutoConfiguration.class})
@ConditionalOnProperty(prefix="coffeenet.discovery", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CoffeeNetDiscoveryAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={EurekaDiscoveryClient.class})
    @ConditionalOnProperty(prefix="coffeenet", name={"profile"}, havingValue="integration")
    @EnableConfigurationProperties(value={CoffeeNetConfigurationProperties.class, CoffeeNetDiscoveryProperties.class})
    static class CoffeeNetDiscoveryPropertiesConfiguration {
        private final CoffeeNetConfigurationProperties coffeeNetConfigurationProperties;

        @Autowired
        CoffeeNetDiscoveryPropertiesConfiguration(CoffeeNetConfigurationProperties coffeeNetConfigurationProperties) {
            this.coffeeNetConfigurationProperties = coffeeNetConfigurationProperties;
        }

        @Bean
        CoffeeNetDiscoveryInstanceProperties eurekaInstanceConfigBean(InetUtils inetUtils, ConfigurableEnvironment env) throws MalformedURLException {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)env);
            RelaxedPropertyResolver coffeeNetPropertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "coffeenet.discovery.instance.");
            String hostname = coffeeNetPropertyResolver.getProperty("hostname");
            boolean preferIpAddress = Boolean.parseBoolean(coffeeNetPropertyResolver.getProperty("preferIpAddress"));
            int nonSecurePort = Integer.parseInt(resolver.getProperty("server.port", resolver.getProperty("port", "8080")));
            int managementPort = Integer.parseInt(resolver.getProperty("management.port", String.valueOf(nonSecurePort)));
            String managementContextPath = resolver.getProperty("management.contextPath", resolver.getProperty("server.contextPath", "/"));
            CoffeeNetDiscoveryInstanceProperties instance = new CoffeeNetDiscoveryInstanceProperties(inetUtils, this.coffeeNetConfigurationProperties);
            instance.setNonSecurePort(nonSecurePort);
            instance.setInstanceId(IdUtils.getDefaultInstanceId((PropertyResolver)resolver));
            instance.setPreferIpAddress(preferIpAddress);
            if (managementPort != nonSecurePort && managementPort != 0) {
                if (StringUtils.hasText((String)hostname)) {
                    instance.setHostname(hostname);
                }
                String statusPageUrlPath = coffeeNetPropertyResolver.getProperty("statusPageUrlPath");
                String healthCheckUrlPath = coffeeNetPropertyResolver.getProperty("healthCheckUrlPath");
                if (!managementContextPath.endsWith(File.separator)) {
                    managementContextPath = managementContextPath + File.separator;
                }
                if (StringUtils.hasText((String)statusPageUrlPath)) {
                    instance.setStatusPageUrlPath(statusPageUrlPath);
                }
                if (StringUtils.hasText((String)healthCheckUrlPath)) {
                    instance.setHealthCheckUrlPath(healthCheckUrlPath);
                }
                String scheme = instance.getSecurePortEnabled() ? "https" : "http";
                URL base = new URL(scheme, instance.getHostname(), managementPort, managementContextPath);
                instance.setStatusPageUrl(new URL(base, StringUtils.trimLeadingCharacter((String)instance.getStatusPageUrlPath(), (char)'/')).toString());
                instance.setHealthCheckUrl(new URL(base, StringUtils.trimLeadingCharacter((String)instance.getHealthCheckUrlPath(), (char)'/')).toString());
            }
            return instance;
        }

        @Bean
        CoffeeNetDiscoveryClientProperties eurekaClientConfigBean() {
            return new CoffeeNetDiscoveryClientProperties();
        }
    }

    @Configuration
    @EnableDiscoveryClient
    @ConditionalOnClass(value={EurekaClientConfig.class})
    @ConditionalOnProperty(prefix="coffeenet", name={"profile"}, havingValue="integration")
    static class IntegrationCoffeeNetServiceDiscoveryConfiguration {
        private final DiscoveryClient discoveryClient;

        @Autowired
        public IntegrationCoffeeNetServiceDiscoveryConfiguration(DiscoveryClient discoveryClient) {
            this.discoveryClient = discoveryClient;
        }

        @Bean
        @ConditionalOnMissingBean(value={CoffeeNetAppService.class})
        CoffeeNetAppService coffeeNetAppService() {
            return new IntegrationCoffeeNetAppService(this.discoveryClient);
        }
    }

    @Configuration
    @ConditionalOnClass(value={EurekaClientConfig.class})
    @ConditionalOnProperty(prefix="coffeenet", name={"profile"}, havingValue="development", matchIfMissing=true)
    static class DevelopmentCoffeeNetServiceDiscoveryConfiguration {
        DevelopmentCoffeeNetServiceDiscoveryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={CoffeeNetAppService.class})
        CoffeeNetAppService coffeeNetAppService() {
            return new DevelopmentCoffeeNetAppService();
        }
    }
}

