/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.navigation;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.info.ProjectInfoAutoConfiguration;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import rocks.coffeenet.autoconfigure.CoffeeNetConfigurationProperties;
import rocks.coffeenet.autoconfigure.discovery.config.CoffeeNetDiscoveryAutoConfiguration;
import rocks.coffeenet.autoconfigure.discovery.config.CoffeeNetDiscoveryInstanceProperties;
import rocks.coffeenet.autoconfigure.discovery.service.CoffeeNetAppService;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationDataExtractor;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationEndpoint;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationInterceptor;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationProperties;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationService;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationServiceImpl;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetWebMvcConfigurerAdapter;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetSecurityAutoConfiguration;
import rocks.coffeenet.autoconfigure.security.service.CoffeeNetCurrentUserService;

@Configuration
@ConditionalOnResource(resources={"classpath:/static/css/coffeenet-navbar.css"})
@AutoConfigureAfter(value={CoffeeNetDiscoveryAutoConfiguration.class, CoffeeNetSecurityAutoConfiguration.class, ProjectInfoAutoConfiguration.class})
public class CoffeeNetNavigationAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Bean
    public CoffeeNetNavigationProperties coffeeNetNavigationProperties() {
        return new CoffeeNetNavigationProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={CoffeeNetNavigationDataExtractor.class})
    public CoffeeNetNavigationDataExtractor coffeeNetNavigationDataExtractor(CoffeeNetNavigationProperties coffeeNetNavigationProperties) {
        CoffeeNetNavigationDataExtractor coffeeNetNavigationDataExtractor = new CoffeeNetNavigationDataExtractor(coffeeNetNavigationProperties);
        LOGGER.info("//> Created the CoffeeNetNavigationDataExtractor");
        return coffeeNetNavigationDataExtractor;
    }

    @Bean
    @ConditionalOnMissingBean(value={CoffeeNetNavigationService.class})
    public CoffeeNetNavigationService coffeeNetWebService(CoffeeNetNavigationDataExtractor coffeeNetNavigationDataExtractor) {
        CoffeeNetNavigationServiceImpl coffeeNetNavigationService = new CoffeeNetNavigationServiceImpl(coffeeNetNavigationDataExtractor);
        LOGGER.info("//> Created the CoffeeNetNavigationService");
        return coffeeNetNavigationService;
    }

    @Configuration
    @ConditionalOnBean(value={CoffeeNetAppService.class})
    @ConditionalOnProperty(prefix="coffeenet", name={"profile"}, havingValue="integration")
    static class CoffeeNetRegisterNavigationAppInformation {
        @Autowired
        CoffeeNetRegisterNavigationAppInformation(CoffeeNetConfigurationProperties coffeeNetConfigurationProperties, CoffeeNetNavigationProperties coffeeNetNavigationProperties, CoffeeNetDiscoveryInstanceProperties coffeeNetDiscoveryInstanceProperties) {
            String allowedRoles = this.extractAllowedRolesToDisplayInNavigation(coffeeNetConfigurationProperties, coffeeNetNavigationProperties);
            if (allowedRoles != null) {
                coffeeNetDiscoveryInstanceProperties.getMetadataMap().put("allowedAuthorities", allowedRoles);
                LOGGER.debug("//> Added {} to allowedAuthorities", (Object)allowedRoles);
            }
        }

        private String extractAllowedRolesToDisplayInNavigation(CoffeeNetConfigurationProperties coffeeNetConfigurationProperties, CoffeeNetNavigationProperties coffeeNetNavigationProperties) {
            String allowedAuthorities = coffeeNetNavigationProperties.getDisplayInNavigationForRoles();
            if (coffeeNetConfigurationProperties.getAllowedAuthorities() != null) {
                allowedAuthorities = allowedAuthorities.concat("," + coffeeNetConfigurationProperties.getAllowedAuthorities());
            }
            return allowedAuthorities;
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:/META-INF/resources/webjars/navigation-bar/bundle.js"})
    public static class CoffeeNetWebClientSideRenderingConfiguration {
        @Bean
        @Autowired
        @ConditionalOnMissingBean(value={CoffeeNetNavigationEndpoint.class})
        public CoffeeNetNavigationEndpoint coffeeNetWebEndpoint(CoffeeNetNavigationService coffeeNetNavigationService) {
            return new CoffeeNetNavigationEndpoint(coffeeNetNavigationService);
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:/templates/coffeenet/_layout.html"})
    public static class CoffeeNetWebServerSideRenderingConfiguration {
        @Bean
        @Autowired
        @ConditionalOnMissingBean(value={CoffeeNetNavigationInterceptor.class})
        public CoffeeNetNavigationInterceptor coffeeNetInterceptor(CoffeeNetNavigationService coffeeNetNavigationService) {
            CoffeeNetNavigationInterceptor coffeeNetNavigationInterceptor = new CoffeeNetNavigationInterceptor(coffeeNetNavigationService);
            LOGGER.info("//> Created the CoffeeNet handler interceptor");
            return coffeeNetNavigationInterceptor;
        }

        @Bean
        @Autowired
        @ConditionalOnMissingBean(value={CoffeeNetWebMvcConfigurerAdapter.class})
        public CoffeeNetWebMvcConfigurerAdapter coffeeNetWebMvcConfigurerAdapter(CoffeeNetNavigationInterceptor coffeeNetNavigationInterceptor) {
            CoffeeNetWebMvcConfigurerAdapter coffeeNetWebMvcConfigurerAdapter = new CoffeeNetWebMvcConfigurerAdapter(coffeeNetNavigationInterceptor);
            LOGGER.info("//> Created the CoffeeNetWebMvcConfigurerAdapter");
            return coffeeNetWebMvcConfigurerAdapter;
        }
    }

    @Configuration
    @ConditionalOnBean(value={BuildProperties.class})
    static class BuildPropertiesConfiguration {
        @Autowired
        BuildPropertiesConfiguration(CoffeeNetNavigationDataExtractor coffeeNetNavigationDataExtractor, BuildProperties buildProperties, CoffeeNetNavigationProperties coffeeNetNavigationProperties) {
            if (coffeeNetNavigationProperties.isDisplayVersions()) {
                coffeeNetNavigationDataExtractor.registerService(CoffeeNetNavigationDataExtractor.CoffeeNetServices.BUILD_PROPERTIES, buildProperties);
                LOGGER.info("//> Added the BuildProperties to the CoffeeNetWebExtractor");
            }
        }
    }

    @Configuration
    @ConditionalOnBean(value={CoffeeNetAppService.class})
    static class CoffeeNetAppServiceConfiguration {
        @Autowired
        CoffeeNetAppServiceConfiguration(CoffeeNetNavigationDataExtractor coffeeNetNavigationDataExtractor, CoffeeNetAppService coffeeNetAppService) {
            coffeeNetNavigationDataExtractor.registerService(CoffeeNetNavigationDataExtractor.CoffeeNetServices.APP_SERVICE, coffeeNetAppService);
            LOGGER.info("//> Added the CoffeeNetAppService to the CoffeeNetNavigationDataExtractor");
        }
    }

    @Configuration
    @ConditionalOnBean(value={CoffeeNetCurrentUserService.class})
    static class CoffeeNetCurrentUserServiceConfiguration {
        @Autowired
        CoffeeNetCurrentUserServiceConfiguration(CoffeeNetNavigationDataExtractor coffeeNetNavigationDataExtractor, CoffeeNetCurrentUserService coffeeNetCurrentUserService) {
            coffeeNetNavigationDataExtractor.registerService(CoffeeNetNavigationDataExtractor.CoffeeNetServices.USER_SERVICE, coffeeNetCurrentUserService);
            LOGGER.info("//> Added the CoffeeNetCurrentUserService to the CoffeeNetNavigationDataExtractor");
        }
    }
}

