/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.navigation;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import rocks.coffeenet.autoconfigure.navigation.CoffeeNetNavigationService;

public class CoffeeNetNavigationInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoffeeNetNavigationService coffeeNetNavigationService;

    CoffeeNetNavigationInterceptor(CoffeeNetNavigationService coffeeNetNavigationService) {
        this.coffeeNetNavigationService = coffeeNetNavigationService;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        boolean isNotRedirect;
        if (modelAndView == null) {
            LOGGER.debug("//> Ignoring intercepted empty model and view for request: {}", (Object)request);
            return;
        }
        String view = Optional.ofNullable(modelAndView.getViewName()).orElse("");
        boolean bl = isNotRedirect = !view.contains("redirect:");
        if (isNotRedirect) {
            modelAndView.addObject("coffeenet", (Object)this.coffeeNetNavigationService.get());
            LOGGER.debug("//> Added CoffeeNetNavigationInformation to the intercepted model and view '{}'", (Object)view);
        } else {
            LOGGER.debug("//> Ignoring intercepted view target: '{}'", (Object)view);
        }
    }
}

