/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.config;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.StringUtils;

public class CoffeeNetAuthoritiesExtractor
implements AuthoritiesExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String AUTHORITIES = "authorities";
    private static final String PRINCIPAL = "principal";
    private static final String DEFAULT_AUTHORITY = "ROLE_UNKNOWN";
    private static final String ERROR_MSG = "Could not extract authorities. Using default authority: ROLE_UNKNOWN";

    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        List<GrantedAuthority> authoritiesList;
        if (map.containsKey(PRINCIPAL) && map.get(PRINCIPAL) instanceof Map) {
            authoritiesList = CoffeeNetAuthoritiesExtractor.extractAuthoritiesOutOfPrincipal((Map)map.get(PRINCIPAL));
        } else {
            LOGGER.warn(ERROR_MSG);
            authoritiesList = AuthorityUtils.commaSeparatedStringToAuthorityList((String)DEFAULT_AUTHORITY);
        }
        return authoritiesList;
    }

    private static List<GrantedAuthority> extractAuthoritiesOutOfPrincipal(Map principal) {
        List authoritiesList;
        if (principal.containsKey(AUTHORITIES) && principal.get(AUTHORITIES) instanceof Collection) {
            String authorities = StringUtils.collectionToCommaDelimitedString((Collection)((Collection)principal.get(AUTHORITIES)));
            authoritiesList = AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities);
        } else {
            LOGGER.warn(ERROR_MSG);
            authoritiesList = AuthorityUtils.commaSeparatedStringToAuthorityList((String)DEFAULT_AUTHORITY);
        }
        return authoritiesList;
    }
}

