/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.config;

import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetAuthoritiesExtractor;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetPrincipalExtractor;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetSecurityClientProperties;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetSecurityProperties;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetSecurityResourceProperties;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetSimpleUrlAuthenticationFailureHandler;
import rocks.coffeenet.autoconfigure.security.config.DevelopmentCoffeeNetWebSecurityConfigurerAdapter;
import rocks.coffeenet.autoconfigure.security.config.IntegrationCoffeeNetWebSecurityConfigurerAdapter;
import rocks.coffeenet.autoconfigure.security.service.CoffeeNetCurrentUserService;
import rocks.coffeenet.autoconfigure.security.service.DevelopmentCoffeeNetCurrentUserService;
import rocks.coffeenet.autoconfigure.security.service.IntegrationCoffeeNetCurrentUserService;

@Configuration
@ConditionalOnClass(value={OAuth2ClientContext.class, WebSecurityConfigurerAdapter.class})
@ConditionalOnProperty(prefix="coffeenet.security", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CoffeeNetSecurityAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(prefix="coffeenet", name={"profile"}, havingValue="integration")
    @EnableConfigurationProperties(value={CoffeeNetSecurityProperties.class, CoffeeNetSecurityClientProperties.class, CoffeeNetSecurityResourceProperties.class})
    @EnableOAuth2Client
    public static class IntegrationCoffeeNetSecurityConfiguration {
        private static final String LOGIN = "/login";
        private static final int OAUTH_CLIENT_CONTEXT_FILTER_ORDER = -100;
        private final CoffeeNetSecurityClientProperties coffeeNetSecurityClientProperties;
        private final CoffeeNetSecurityResourceProperties coffeeNetSecurityResourceProperties;
        private final CoffeeNetSecurityProperties coffeeNetSecurityProperties;

        @Autowired
        public IntegrationCoffeeNetSecurityConfiguration(CoffeeNetSecurityClientProperties coffeeNetSecurityClientProperties, CoffeeNetSecurityResourceProperties coffeeNetSecurityResourceProperties, CoffeeNetSecurityProperties coffeeNetSecurityProperties) {
            this.coffeeNetSecurityClientProperties = coffeeNetSecurityClientProperties;
            this.coffeeNetSecurityResourceProperties = coffeeNetSecurityResourceProperties;
            this.coffeeNetSecurityProperties = coffeeNetSecurityProperties;
        }

        @Bean
        public FilterRegistrationBean coffeeNetOauth2ClientFilterRegistration(OAuth2ClientContextFilter oAuth2ClientContextFilter) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)oAuth2ClientContextFilter);
            registration.setOrder(-100);
            return registration;
        }

        @Bean
        @ConditionalOnMissingBean(value={CoffeeNetCurrentUserService.class})
        public CoffeeNetCurrentUserService coffeeNetCurrentUserService() {
            return new IntegrationCoffeeNetCurrentUserService();
        }

        @Bean
        @ConditionalOnMissingBean
        public IntegrationCoffeeNetWebSecurityConfigurerAdapter integrationCoffeeNetWebSecurityConfigurerAdapter() {
            return new IntegrationCoffeeNetWebSecurityConfigurerAdapter();
        }

        @Bean
        @ConditionalOnMissingBean(value={OAuth2RestTemplate.class})
        public OAuth2RestTemplate coffeeNetUserInfoRestTemplate(OAuth2ClientContext oauth2ClientContext) {
            return new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)this.coffeeNetSecurityClientProperties, oauth2ClientContext);
        }

        @Bean
        @ConditionalOnMissingBean(value={UserInfoTokenServices.class})
        public UserInfoTokenServices coffeeNetUserInfoTokenServices(OAuth2RestTemplate coffeeNetUserInfoRestTemplate, AuthoritiesExtractor authoritiesExtractor, PrincipalExtractor principalExtractor) {
            UserInfoTokenServices userInfoTokenServices = new UserInfoTokenServices(this.coffeeNetSecurityResourceProperties.getUserInfoUri(), this.coffeeNetSecurityClientProperties.getClientId());
            userInfoTokenServices.setAuthoritiesExtractor(authoritiesExtractor);
            userInfoTokenServices.setPrincipalExtractor(principalExtractor);
            userInfoTokenServices.setRestTemplate((OAuth2RestOperations)coffeeNetUserInfoRestTemplate);
            return userInfoTokenServices;
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthoritiesExtractor.class})
        public AuthoritiesExtractor coffeeNetAuthoritiesExtractor() {
            return new CoffeeNetAuthoritiesExtractor();
        }

        @Bean
        @ConditionalOnMissingBean(value={PrincipalExtractor.class})
        public PrincipalExtractor coffeeNetPrincipalExtractor(AuthoritiesExtractor authoritiesExtractor) {
            return new CoffeeNetPrincipalExtractor(authoritiesExtractor);
        }

        @Bean
        @ConditionalOnMissingBean(value={OAuth2ClientAuthenticationProcessingFilter.class})
        public OAuth2ClientAuthenticationProcessingFilter oAuth2ClientAuthenticationProcessingFilter(OAuth2RestTemplate userInfoRestTemplate, UserInfoTokenServices userInfoTokenServices, AuthenticationSuccessHandler defaultLoginSuccessUrlHandler, AuthenticationFailureHandler defaultAuthenticationFailureHandler) {
            OAuth2ClientAuthenticationProcessingFilter oAuthFilter = new OAuth2ClientAuthenticationProcessingFilter(LOGIN);
            oAuthFilter.setRestTemplate((OAuth2RestOperations)userInfoRestTemplate);
            oAuthFilter.setTokenServices((ResourceServerTokenServices)userInfoTokenServices);
            oAuthFilter.setAuthenticationSuccessHandler(defaultLoginSuccessUrlHandler);
            oAuthFilter.setAuthenticationFailureHandler(defaultAuthenticationFailureHandler);
            return oAuthFilter;
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthenticationSuccessHandler.class})
        public AuthenticationSuccessHandler defaultLoginSuccessUrlHandler() {
            SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
            if (this.coffeeNetSecurityProperties.getDefaultLoginSuccessUrl() != null) {
                handler.setDefaultTargetUrl(this.coffeeNetSecurityProperties.getDefaultLoginSuccessUrl());
                handler.setAlwaysUseDefaultTargetUrl(true);
            }
            return handler;
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthenticationFailureHandler.class})
        public AuthenticationFailureHandler defaultAuthenticationFailureHandler() {
            CoffeeNetSimpleUrlAuthenticationFailureHandler failureHandler = new CoffeeNetSimpleUrlAuthenticationFailureHandler();
            if (this.coffeeNetSecurityProperties.getDefaultLoginFailureUrl() != null) {
                failureHandler.setDefaultFailureUrl(this.coffeeNetSecurityProperties.getDefaultLoginFailureUrl());
            }
            return failureHandler;
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="coffeenet", name={"profile"}, havingValue="development", matchIfMissing=true)
    @EnableConfigurationProperties(value={CoffeeNetSecurityProperties.class})
    public static class DevelopmentCoffeeNetSecurityConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={CoffeeNetCurrentUserService.class})
        public CoffeeNetCurrentUserService coffeeNetCurrentUserService() {
            return new DevelopmentCoffeeNetCurrentUserService();
        }

        @Bean
        @ConditionalOnMissingBean
        public DevelopmentCoffeeNetWebSecurityConfigurerAdapter coffeeWebSecurityConfigurerAdapter() {
            return new DevelopmentCoffeeNetWebSecurityConfigurerAdapter();
        }
    }
}

