/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.config;

import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="coffeenet.security.client")
public class CoffeeNetSecurityClientProperties
extends AuthorizationCodeResourceDetails {
    @URL(message="Please provide a valid url to your oauth token endpoint")
    @NotBlank(message="Please provide the token endpoint of the oauth server usually ending with /oauth/token")
    private String accessTokenUri = "http://localhost:9999/oauth/token";
    @URL(message="Please provide a valid url to your oauth authorize endpoint")
    @NotBlank(message="Please provide the authorize endpoint of the oauth server usually ending with /oauth/authorize")
    private String userAuthorizationUri = "http://localhost:9999/oauth/authorize";

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public void setAccessTokenUri(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    public String getUserAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public void setUserAuthorizationUri(String userAuthorizationUri) {
        this.userAuthorizationUri = userAuthorizationUri;
    }

    public String toString() {
        return "CoffeeNetSecurityClientProperties{accessTokenUri='" + this.accessTokenUri + '\'' + ", userAuthorizationUri='" + this.userAuthorizationUri + '\'' + '}';
    }
}

