/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.config;

import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="coffeenet.security")
public class CoffeeNetSecurityProperties {
    @NotNull
    private boolean enabled = true;
    @URL(message="Please provide a valid url to your oauth logout endpoint")
    @NotBlank(message="Please provide the logout endpoint of the oauth server usually ending with /logout")
    private String logoutSuccessUrl = "http://localhost:9999/logout";
    private String defaultLoginSuccessUrl;
    @NotBlank(message="Please provide a default login failure url. The user will be redirected to this url on a failed authentication. Otherwise the user would see a white label error page.")
    private String defaultLoginFailureUrl = "/";

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public String getDefaultLoginSuccessUrl() {
        return this.defaultLoginSuccessUrl;
    }

    public void setDefaultLoginSuccessUrl(String defaultLoginSuccessUrl) {
        this.defaultLoginSuccessUrl = defaultLoginSuccessUrl;
    }

    public String getDefaultLoginFailureUrl() {
        return this.defaultLoginFailureUrl;
    }

    public void setDefaultLoginFailureUrl(String defaultLoginFailureUrl) {
        this.defaultLoginFailureUrl = defaultLoginFailureUrl;
    }

    public String toString() {
        return "CoffeeNetSecurityProperties{enabled=" + this.enabled + ", logoutSuccessUrl='" + this.logoutSuccessUrl + '\'' + ", defaultLoginSuccessUrl='" + this.defaultLoginSuccessUrl + '\'' + ", defaultLoginFailureUrl='" + this.defaultLoginFailureUrl + '\'' + '}';
    }
}

