/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.config;

import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationManager;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationProcessingFilter;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetSecurityProperties;
import rocks.coffeenet.autoconfigure.security.config.CoffeeNetSecurityResourceProperties;

@EnableConfigurationProperties(value={CoffeeNetSecurityProperties.class})
public class IntegrationCoffeeNetWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    private static final String LOGIN = "/login";
    private static final String LOGOUT = "/logout";
    private CoffeeNetSecurityProperties securityConfigurationProperties;
    private CoffeeNetSecurityResourceProperties coffeenetResource;
    private UserInfoTokenServices userInfoTokenServices;
    private OAuth2ClientAuthenticationProcessingFilter oAuth2ClientAuthenticationProcessingFilter;

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)this.enableSso(http).authorizeRequests().anyRequest()).authenticated().and()).csrf().disable();
    }

    public HttpSecurity enableSso(HttpSecurity http) throws Exception {
        return (HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.logout().logoutUrl(LOGOUT).logoutSuccessUrl(this.securityConfigurationProperties.getLogoutSuccessUrl()).and()).exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(LOGIN), (RequestMatcher)IntegrationCoffeeNetWebSecurityConfigurerAdapter.mediaTypeRequestMatcher((ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class))).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest")).and()).addFilterBefore((Filter)this.oAuth2ClientAuthenticationProcessingFilter, BasicAuthenticationFilter.class).addFilterBefore(this.apiTokenAccessFilter(), AbstractPreAuthenticatedProcessingFilter.class).authorizeRequests().antMatchers(new String[]{"/health", "/info"})).permitAll().and();
    }

    private Filter apiTokenAccessFilter() {
        OAuth2AuthenticationProcessingFilter apiTokenAccessFilter = new OAuth2AuthenticationProcessingFilter();
        apiTokenAccessFilter.setStateless(false);
        OAuth2AuthenticationManager oauthAuthenticationManager = new OAuth2AuthenticationManager();
        oauthAuthenticationManager.setResourceId(this.coffeenetResource.getResourceId());
        oauthAuthenticationManager.setTokenServices((ResourceServerTokenServices)this.userInfoTokenServices);
        oauthAuthenticationManager.setClientDetailsService(null);
        apiTokenAccessFilter.setAuthenticationManager((AuthenticationManager)oauthAuthenticationManager);
        return apiTokenAccessFilter;
    }

    private static MediaTypeRequestMatcher mediaTypeRequestMatcher(ContentNegotiationStrategy contentNegotiationStrategy) {
        ContentNegotiationStrategy negotiationStrategy = contentNegotiationStrategy;
        if (negotiationStrategy == null) {
            negotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher matcher = new MediaTypeRequestMatcher(negotiationStrategy, new MediaType[]{MediaType.APPLICATION_XHTML_XML, new MediaType("image", "*"), MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
        matcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        return matcher;
    }

    @Autowired
    public void setCoffeeNetSecurityProperties(CoffeeNetSecurityProperties securityConfigurationProperties) {
        this.securityConfigurationProperties = securityConfigurationProperties;
    }

    @Autowired
    public void setCoffeeNetSecurityResourceProperties(CoffeeNetSecurityResourceProperties coffeenetResource) {
        this.coffeenetResource = coffeenetResource;
    }

    @Autowired
    public void setUserInfoTokenServices(UserInfoTokenServices userInfoTokenServices) {
        this.userInfoTokenServices = userInfoTokenServices;
    }

    @Autowired
    public void setOAuth2ClientAuthenticationProcessingFilter(OAuth2ClientAuthenticationProcessingFilter oAuth2ClientAuthenticationProcessingFilter) {
        this.oAuth2ClientAuthenticationProcessingFilter = oAuth2ClientAuthenticationProcessingFilter;
    }
}

