/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.autoconfigure.security.service;

import java.util.Collection;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import rocks.coffeenet.autoconfigure.security.service.CoffeeNetCurrentUserService;
import rocks.coffeenet.autoconfigure.security.service.CoffeeNetUserDetails;
import rocks.coffeenet.autoconfigure.security.service.HumanCoffeeNetUser;

public class DevelopmentCoffeeNetCurrentUserService
implements CoffeeNetCurrentUserService {
    @Override
    public Optional<CoffeeNetUserDetails> get() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return Optional.empty();
        }
        User user = (User)authentication.getPrincipal();
        return DevelopmentCoffeeNetCurrentUserService.getCoffeeNetUserDetails(user);
    }

    private static Optional<CoffeeNetUserDetails> getCoffeeNetUserDetails(User user) {
        String username = user.getUsername();
        Collection authorities = user.getAuthorities();
        return Optional.of(new HumanCoffeeNetUser(username, username + "@coffeenet", authorities));
    }
}

