/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.frontpage.plugin.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import rocks.coffeenet.frontpage.plugin.api.ConfigurationField;

public interface ConfigurationDescription
extends Iterable<ConfigurationField> {
    public Set<ConfigurationField> getConfigurations();

    @Override
    default public Iterator<ConfigurationField> iterator() {
        return this.getConfigurations().iterator();
    }

    @Override
    default public Spliterator<ConfigurationField> spliterator() {
        return this.getConfigurations().spliterator();
    }

    @Override
    default public void forEach(Consumer<? super ConfigurationField> action) {
        this.getConfigurations().forEach(action);
    }

    public static class Builder {
        private final Set<ConfigurationField> fields = new HashSet<ConfigurationField>();

        public Builder withConfigurationField(ConfigurationField field) {
            this.fields.add(field);
            return this;
        }

        public ConfigurationDescription build() {
            return () -> Collections.unmodifiableSet(this.fields);
        }
    }
}

