/*
 * Decompiled with CFR 0.152.
 */
package rocks.coffeenet.frontpage.plugin.api;

import rocks.coffeenet.frontpage.plugin.api.ConfigurationFieldType;

public interface ConfigurationField {
    public String getLabel();

    public ConfigurationFieldType getType();

    default public boolean isRequired() {
        return false;
    }

    public String getId();

    public static class Builder {
        private String id;
        private String label;
        private ConfigurationFieldType type;
        private boolean required;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder type(ConfigurationFieldType type) {
            this.type = type;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public ConfigurationField build() {
            return new ConfigurationField(){

                @Override
                public String getLabel() {
                    return label;
                }

                @Override
                public ConfigurationFieldType getType() {
                    return type;
                }

                @Override
                public String getId() {
                    return id;
                }

                @Override
                public boolean isRequired() {
                    return required;
                }
            };
        }
    }
}

