/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.android.release.gradle;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import rocks.frieler.android.release.gradle.GitRepository;
import rocks.frieler.android.release.gradle.ScmChecksKt;
import rocks.frieler.android.release.gradle.StringsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0002R\u001c\u0010\u0003\u001a\u00020\u00048AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lrocks/frieler/android/release/gradle/PerformRelease;", "Lorg/gradle/api/DefaultTask;", "()V", "scmRepository", "Lrocks/frieler/android/release/gradle/GitRepository;", "getScmRepository$android_release_gradle_plugin", "()Lrocks/frieler/android/release/gradle/GitRepository;", "setScmRepository$android_release_gradle_plugin", "(Lrocks/frieler/android/release/gradle/GitRepository;)V", "performRelease", "", "unsnapshotVersion", "", "android-release-gradle-plugin"})
public class PerformRelease
extends DefaultTask {
    public GitRepository scmRepository;

    @Input
    @NotNull
    public final GitRepository getScmRepository$android_release_gradle_plugin() {
        GitRepository gitRepository = this.scmRepository;
        if (gitRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        return gitRepository;
    }

    public final void setScmRepository$android_release_gradle_plugin(@NotNull GitRepository gitRepository) {
        Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"<set-?>");
        this.scmRepository = gitRepository;
    }

    @TaskAction
    public final void performRelease() {
        GitRepository gitRepository = this.scmRepository;
        if (gitRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        ScmChecksKt.assertMasterBranch(gitRepository);
        GitRepository gitRepository2 = this.scmRepository;
        if (gitRepository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        ScmChecksKt.assertNoLocalChanges(gitRepository2);
        String releaseVersion = this.unsnapshotVersion();
        GitRepository gitRepository3 = this.scmRepository;
        if (gitRepository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        gitRepository3.commitAllChanges("\"release " + releaseVersion + '\"');
        GitRepository gitRepository4 = this.scmRepository;
        if (gitRepository4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        gitRepository4.tag('\"' + releaseVersion + '\"');
    }

    private final String unsnapshotVersion() {
        String releaseVersion = null;
        StringBuilder newGradleFile = new StringBuilder();
        Regex versionSpecificationPattern = new Regex("^\\s*version\\s*=\\s*\"([^\"]*)\"\\s*$");
        File file = this.getProject().file((Object)"./build.gradle.kts");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"./build.gradle.kts\")");
        Iterable $this$forEach$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            MatchResult match = versionSpecificationPattern.matchEntire((CharSequence)line);
            if (match != null) {
                MatchGroup matchGroup = match.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String currentVersion = matchGroup.getValue();
                boolean bl2 = kotlin.text.StringsKt.endsWith$default((String)currentVersion, (String)"-SNAPSHOT", (boolean)false, (int)2, null);
                boolean bl3 = false;
                boolean bl4 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string = "current version '" + currentVersion + "' is not a SNAPSHOT!";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                releaseVersion = kotlin.text.StringsKt.replace$default((String)currentVersion, (String)"-SNAPSHOT", (String)"", (boolean)false, (int)4, null);
                String string = match.getValue();
                String string2 = releaseVersion;
                Intrinsics.checkNotNull((Object)string2);
                StringsKt.appendLineWithSystemEnding(newGradleFile, kotlin.text.StringsKt.replace$default((String)string, (String)currentVersion, (String)string2, (boolean)false, (int)4, null));
                continue;
            }
            StringsKt.appendLineWithSystemEnding(newGradleFile, line);
        }
        File file2 = this.getProject().file((Object)"./build.gradle.kts");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(\"./build.gradle.kts\")");
        String string = newGradleFile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newGradleFile.toString()");
        FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
        boolean bl = releaseVersion != null;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl) {
            boolean bl8 = false;
            String string3 = "no version specification found!";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String string4 = releaseVersion;
        Intrinsics.checkNotNull((Object)string4);
        return string4;
    }

    public PerformRelease() {
        this.setGroup("versioning");
        this.setDescription("Performs a release by removing the \"-SNAPSHOT\"-suffix from the version name.");
    }
}

