/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.android.release.gradle;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import rocks.frieler.android.release.gradle.GitRepository;
import rocks.frieler.android.release.gradle.ScmChecksKt;
import rocks.frieler.android.release.gradle.StringsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lrocks/frieler/android/release/gradle/PrepareNextDevelopmentVersion;", "Lorg/gradle/api/DefaultTask;", "()V", "appModule", "", "getAppModule", "()Ljava/lang/String;", "setAppModule", "(Ljava/lang/String;)V", "scmRepository", "Lrocks/frieler/android/release/gradle/GitRepository;", "getScmRepository$android_release_gradle_plugin", "()Lrocks/frieler/android/release/gradle/GitRepository;", "setScmRepository$android_release_gradle_plugin", "(Lrocks/frieler/android/release/gradle/GitRepository;)V", "clearChangeLog", "", "increaseVersionCode", "prepareNextDevelopmentVersion", "prepareNextSnapshotVersion", "android-release-gradle-plugin"})
public class PrepareNextDevelopmentVersion
extends DefaultTask {
    public GitRepository scmRepository;
    @Input
    @NotNull
    private String appModule = "app";

    @Input
    @NotNull
    public final GitRepository getScmRepository$android_release_gradle_plugin() {
        GitRepository gitRepository = this.scmRepository;
        if (gitRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        return gitRepository;
    }

    public final void setScmRepository$android_release_gradle_plugin(@NotNull GitRepository gitRepository) {
        Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"<set-?>");
        this.scmRepository = gitRepository;
    }

    @NotNull
    public final String getAppModule() {
        return this.appModule;
    }

    public final void setAppModule(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.appModule = string;
    }

    @TaskAction
    public final void prepareNextDevelopmentVersion() {
        GitRepository gitRepository = this.scmRepository;
        if (gitRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        ScmChecksKt.assertMasterBranch(gitRepository);
        GitRepository gitRepository2 = this.scmRepository;
        if (gitRepository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        ScmChecksKt.assertNoLocalChanges(gitRepository2);
        String nextDevelopmentVersion = this.prepareNextSnapshotVersion();
        this.increaseVersionCode();
        this.clearChangeLog();
        GitRepository gitRepository3 = this.scmRepository;
        if (gitRepository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        }
        gitRepository3.commitAllChanges("prepare " + nextDevelopmentVersion);
    }

    private final String prepareNextSnapshotVersion() {
        String nextSnapshotVersion = null;
        StringBuilder newGradleFile = new StringBuilder();
        Regex versionSpecificationPattern = new Regex("^\\s*version\\s*=\\s*\"([^\"]*)\"\\s*$");
        File file = this.getProject().file((Object)"./build.gradle.kts");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"./build.gradle.kts\")");
        Iterable $this$forEach$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            MatchResult match = versionSpecificationPattern.matchEntire((CharSequence)line);
            if (match != null) {
                MatchGroup matchGroup = match.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String currentVersion = matchGroup.getValue();
                Regex versionPattern = new Regex("^(\\d+)\\.(\\d+)\\.\\d+$");
                MatchResult versionMatch = versionPattern.matchEntire((CharSequence)currentVersion);
                boolean bl2 = versionMatch != null;
                boolean bl3 = false;
                boolean bl4 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string = "current version '" + currentVersion + "' does not match pattern <major>.<minor>.<fix>!";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                MatchGroup matchGroup2 = versionMatch.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup2);
                String string = matchGroup2.getValue();
                bl4 = false;
                int major = Integer.parseInt(string);
                MatchGroup matchGroup3 = versionMatch.getGroups().get(2);
                Intrinsics.checkNotNull((Object)matchGroup3);
                String string2 = matchGroup3.getValue();
                boolean bl6 = false;
                int minor = Integer.parseInt(string2);
                nextSnapshotVersion = "" + major + '.' + (minor + 1) + ".0-SNAPSHOT";
                String string3 = match.getValue();
                String string4 = nextSnapshotVersion;
                Intrinsics.checkNotNull((Object)string4);
                StringsKt.appendLineWithSystemEnding(newGradleFile, kotlin.text.StringsKt.replace$default((String)string3, (String)currentVersion, (String)string4, (boolean)false, (int)4, null));
                continue;
            }
            StringsKt.appendLineWithSystemEnding(newGradleFile, line);
        }
        File file2 = this.getProject().file((Object)"./build.gradle.kts");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(\"./build.gradle.kts\")");
        String string = newGradleFile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newGradleFile.toString()");
        FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
        boolean bl = nextSnapshotVersion != null;
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl) {
            boolean bl9 = false;
            String string5 = "no version specification found!";
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        String string6 = nextSnapshotVersion;
        Intrinsics.checkNotNull((Object)string6);
        return string6;
    }

    private final void increaseVersionCode() {
        StringBuilder newGradleFile = new StringBuilder();
        Regex versionCodeSpecificationPattern = new Regex("^\\s*versionCode\\s*=\\s*(\\d+)\\s*$");
        File file = this.getProject().file((Object)(this.appModule + "/build.gradle.kts"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"$appModule/build.gradle.kts\")");
        Iterable $this$forEach$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            MatchResult versionCodeSpecificationMatch = versionCodeSpecificationPattern.matchEntire((CharSequence)line);
            if (versionCodeSpecificationMatch != null) {
                MatchGroup matchGroup = versionCodeSpecificationMatch.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String string = matchGroup.getValue();
                boolean bl2 = false;
                int currentVersionCode = Integer.parseInt(string);
                StringsKt.appendLineWithSystemEnding(newGradleFile, kotlin.text.StringsKt.replace$default((String)versionCodeSpecificationMatch.getValue(), (String)String.valueOf(currentVersionCode), (String)String.valueOf(currentVersionCode + 1), (boolean)false, (int)4, null));
                continue;
            }
            StringsKt.appendLineWithSystemEnding(newGradleFile, line);
        }
        File file2 = this.getProject().file((Object)(this.appModule + "/build.gradle.kts"));
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(\"$appModule/build.gradle.kts\")");
        String string = newGradleFile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newGradleFile.toString()");
        FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
    }

    private final void clearChangeLog() {
        File file = this.getProject().file((Object)(this.appModule + "/src/main/play/release-notes/de-DE/default.txt"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"$appModule\u2026notes/de-DE/default.txt\")");
        FilesKt.writeText$default((File)file, (String)"", null, (int)2, null);
    }

    public PrepareNextDevelopmentVersion() {
        this.setGroup("versioning");
        this.setDescription("Prepares the next SNAPSHOT version and increases the app's version code.");
    }
}

