/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.android.release.gradle;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import rocks.frieler.android.release.gradle.GitRepository;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lrocks/frieler/android/release/gradle/GitRepository;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "commitAllChanges", "", "commitMessage", "", "getCurrentBranch", "hasLocalChanges", "", "tag", "tagName", "android-release-gradle-plugin"})
public final class GitRepository {
    @NotNull
    private final Project project;

    public GitRepository(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (!this.project.getRootProject().file((Object)".git").isDirectory()) {
            boolean bl = false;
            String string = "project doesn't seem to be a git repository, '.git' directory is missing!";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final String getCurrentBranch() {
        ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
        this.project.exec(arg_0 -> GitRepository.getCurrentBranch$lambda$1((Function1)new Function1<ExecSpec, Unit>(stdOut){
            final /* synthetic */ ByteArrayOutputStream $stdOut;
            {
                this.$stdOut = $stdOut;
                super(1);
            }

            public final void invoke(ExecSpec it) {
                String[] stringArray = new String[]{" "};
                it.setCommandLine(StringsKt.split$default((CharSequence)"git branch --show-current", (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                it.setStandardOutput((OutputStream)this.$stdOut);
            }
        }, arg_0));
        String string = stdOut.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    public final boolean hasLocalChanges() {
        boolean hasUnstagedChanges2 = this.project.exec(arg_0 -> GitRepository.hasLocalChanges$lambda$2(hasLocalChanges.hasUnstagedChanges.1.INSTANCE, arg_0)).getExitValue() != 0;
        boolean hasStagedChanges2 = this.project.exec(arg_0 -> GitRepository.hasLocalChanges$lambda$3(hasLocalChanges.hasStagedChanges.1.INSTANCE, arg_0)).getExitValue() != 0;
        return hasUnstagedChanges2 || hasStagedChanges2;
    }

    public final void commitAllChanges(@NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        this.project.exec(arg_0 -> GitRepository.commitAllChanges$lambda$4((Function1)new Function1<ExecSpec, Unit>(commitMessage){
            final /* synthetic */ String $commitMessage;
            {
                this.$commitMessage = $commitMessage;
                super(1);
            }

            public final void invoke(ExecSpec it) {
                Object[] objectArray = new String[]{"git", "commit", "-a", "-m", this.$commitMessage};
                it.setCommandLine(CollectionsKt.listOf((Object[])objectArray));
            }
        }, arg_0));
    }

    public final void tag(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        this.project.exec(arg_0 -> GitRepository.tag$lambda$5((Function1)new Function1<ExecSpec, Unit>(tagName){
            final /* synthetic */ String $tagName;
            {
                this.$tagName = $tagName;
                super(1);
            }

            public final void invoke(ExecSpec it) {
                Object[] objectArray = new String[]{"git", "tag", this.$tagName};
                it.setCommandLine(CollectionsKt.listOf((Object[])objectArray));
            }
        }, arg_0));
    }

    private static final void getCurrentBranch$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void hasLocalChanges$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void hasLocalChanges$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void commitAllChanges$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void tag$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

