/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.android.release.gradle;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import rocks.frieler.android.release.gradle.GitRepository;
import rocks.frieler.android.release.gradle.ScmChecksKt;
import rocks.frieler.android.release.gradle.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lrocks/frieler/android/release/gradle/PrepareNextDevelopmentVersion;", "Lorg/gradle/api/DefaultTask;", "()V", "appModule", "", "getAppModule", "()Ljava/lang/String;", "setAppModule", "(Ljava/lang/String;)V", "scmRepository", "Lrocks/frieler/android/release/gradle/GitRepository;", "getScmRepository$android_release_gradle_plugin", "()Lrocks/frieler/android/release/gradle/GitRepository;", "setScmRepository$android_release_gradle_plugin", "(Lrocks/frieler/android/release/gradle/GitRepository;)V", "clearChangeLog", "", "increaseVersionCode", "prepareNextDevelopmentVersion", "prepareNextSnapshotVersion", "android-release-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nPrepareNextDevelopmentVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrepareNextDevelopmentVersion.kt\nrocks/frieler/android/release/gradle/PrepareNextDevelopmentVersion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1855#2:86\n1856#2:88\n1855#2,2:89\n1#3:87\n*S KotlinDebug\n*F\n+ 1 PrepareNextDevelopmentVersion.kt\nrocks/frieler/android/release/gradle/PrepareNextDevelopmentVersion\n*L\n45#1:86\n45#1:88\n69#1:89,2\n*E\n"})
public class PrepareNextDevelopmentVersion
extends DefaultTask {
    public GitRepository scmRepository;
    @Input
    @NotNull
    private String appModule = "app";

    public PrepareNextDevelopmentVersion() {
        this.setGroup("versioning");
        this.setDescription("Prepares the next SNAPSHOT version and increases the app's version code.");
    }

    @Input
    @NotNull
    public final GitRepository getScmRepository$android_release_gradle_plugin() {
        GitRepository gitRepository = this.scmRepository;
        if (gitRepository != null) {
            return gitRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        return null;
    }

    public final void setScmRepository$android_release_gradle_plugin(@NotNull GitRepository gitRepository) {
        Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"<set-?>");
        this.scmRepository = gitRepository;
    }

    @NotNull
    public final String getAppModule() {
        return this.appModule;
    }

    public final void setAppModule(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.appModule = string;
    }

    @TaskAction
    public final void prepareNextDevelopmentVersion() {
        ScmChecksKt.assertMasterBranch(this.getScmRepository$android_release_gradle_plugin());
        ScmChecksKt.assertNoLocalChanges(this.getScmRepository$android_release_gradle_plugin());
        String nextDevelopmentVersion = this.prepareNextSnapshotVersion();
        this.increaseVersionCode();
        this.clearChangeLog();
        this.getScmRepository$android_release_gradle_plugin().commitAllChanges("prepare " + nextDevelopmentVersion);
    }

    private final String prepareNextSnapshotVersion() {
        String nextSnapshotVersion = null;
        StringBuilder newGradleFile = new StringBuilder();
        Regex versionSpecificationPattern = new Regex("^\\s*version\\s*=\\s*\"([^\"]*)\"\\s*$");
        File file = this.getProject().file((Object)"./build.gradle.kts");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        Iterable $this$forEach$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            MatchResult match = versionSpecificationPattern.matchEntire((CharSequence)line);
            if (match != null) {
                MatchGroup matchGroup = match.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String currentVersion = matchGroup.getValue();
                Regex versionPattern = new Regex("^(\\d+)\\.(\\d+)\\.\\d+$");
                MatchResult versionMatch = versionPattern.matchEntire((CharSequence)currentVersion);
                if (!(versionMatch != null)) {
                    boolean $i$a$-check-PrepareNextDevelopmentVersion$prepareNextSnapshotVersion$1$22 = false;
                    String $i$a$-check-PrepareNextDevelopmentVersion$prepareNextSnapshotVersion$1$22 = "current version '" + currentVersion + "' does not match pattern <major>.<minor>.<fix>!";
                    throw new IllegalStateException($i$a$-check-PrepareNextDevelopmentVersion$prepareNextSnapshotVersion$1$22.toString());
                }
                MatchGroup matchGroup2 = versionMatch.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup2);
                int major = Integer.parseInt(matchGroup2.getValue());
                MatchGroup matchGroup3 = versionMatch.getGroups().get(2);
                Intrinsics.checkNotNull((Object)matchGroup3);
                int minor = Integer.parseInt(matchGroup3.getValue());
                nextSnapshotVersion = "" + major + '.' + (minor + 1) + ".0-SNAPSHOT";
                String string = match.getValue();
                String string2 = nextSnapshotVersion;
                Intrinsics.checkNotNull((Object)string2);
                StringsKt.appendLineWithSystemEnding(newGradleFile, kotlin.text.StringsKt.replace$default((String)string, (String)currentVersion, (String)string2, (boolean)false, (int)4, null));
                continue;
            }
            StringsKt.appendLineWithSystemEnding(newGradleFile, line);
        }
        File file2 = this.getProject().file((Object)"./build.gradle.kts");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file(...)");
        String string = newGradleFile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
        if (!(nextSnapshotVersion != null)) {
            boolean bl = false;
            String string3 = "no version specification found!";
            throw new IllegalStateException(string3.toString());
        }
        String string4 = nextSnapshotVersion;
        Intrinsics.checkNotNull(string4);
        return string4;
    }

    private final void increaseVersionCode() {
        StringBuilder newGradleFile = new StringBuilder();
        Regex versionCodeSpecificationPattern = new Regex("^\\s*versionCode\\s*=\\s*(\\d+)\\s*$");
        File file = this.getProject().file((Object)(this.appModule + "/build.gradle.kts"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        Iterable $this$forEach$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            MatchResult versionCodeSpecificationMatch = versionCodeSpecificationPattern.matchEntire((CharSequence)line);
            if (versionCodeSpecificationMatch != null) {
                MatchGroup matchGroup = versionCodeSpecificationMatch.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                int currentVersionCode = Integer.parseInt(matchGroup.getValue());
                StringsKt.appendLineWithSystemEnding(newGradleFile, kotlin.text.StringsKt.replace$default((String)versionCodeSpecificationMatch.getValue(), (String)String.valueOf(currentVersionCode), (String)String.valueOf(currentVersionCode + 1), (boolean)false, (int)4, null));
                continue;
            }
            StringsKt.appendLineWithSystemEnding(newGradleFile, line);
        }
        File file2 = this.getProject().file((Object)(this.appModule + "/build.gradle.kts"));
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file(...)");
        String string = newGradleFile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
    }

    private final void clearChangeLog() {
        File file = this.getProject().file((Object)(this.appModule + "/src/main/play/release-notes/de-DE/default.txt"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        FilesKt.writeText$default((File)file, (String)"", null, (int)2, null);
    }
}

