/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.android.release.gradle;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lrocks/frieler/android/release/gradle/GitRepository;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "getCurrentBranch", "", "hasLocalChanges", "", "commitAllChanges", "", "commitMessage", "tag", "tagName", "android-release-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGitRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepository.kt\nrocks/frieler/android/release/gradle/GitRepository\n+ 2 TaskInternalExtensions.kt\norg/gradle/internal/extensions/core/TaskInternalExtensionsKt\n*L\n1#1,53:1\n32#2,9:54\n32#2,9:63\n32#2,9:72\n32#2,9:81\n32#2,9:90\n*S KotlinDebug\n*F\n+ 1 GitRepository.kt\nrocks/frieler/android/release/gradle/GitRepository\n*L\n22#1:54,9\n30#1:63,9\n34#1:72,9\n42#1:81,9\n48#1:90,9\n*E\n"})
public final class GitRepository {
    @NotNull
    private final Project project;

    public GitRepository(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (!this.project.getRootProject().file((Object)".git").isDirectory()) {
            boolean bl = false;
            String string = "project doesn't seem to be a git repository, '.git' directory is missing!";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final String getCurrentBranch() {
        ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
        Project $this$serviceOf$iv = this.project;
        boolean $i$f$serviceOf = false;
        ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
        Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(ExecOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this[T::class.java]");
        ((ExecOperations)object).exec(arg_0 -> GitRepository.getCurrentBranch$lambda$2(arg_0 -> GitRepository.getCurrentBranch$lambda$1(stdOut, arg_0), arg_0));
        String string = stdOut.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    public final boolean hasLocalChanges() {
        Project $this$serviceOf$iv = this.project;
        boolean $i$f$serviceOf = false;
        ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
        Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(ExecOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this[T::class.java]");
        boolean hasUnstagedChanges = ((ExecOperations)object).exec(arg_0 -> GitRepository.hasLocalChanges$lambda$4(GitRepository::hasLocalChanges$lambda$3, arg_0)).getExitValue() != 0;
        Project $this$serviceOf$iv2 = this.project;
        boolean $i$f$serviceOf2 = false;
        ServiceRegistry serviceRegistry2 = ((ProjectInternal)$this$serviceOf$iv2).getServices();
        Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry2, (String)"this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv2 = serviceRegistry2;
        boolean $i$f$get2 = false;
        Object object2 = $this$get$iv$iv2.get(ExecOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this[T::class.java]");
        boolean hasStagedChanges = ((ExecOperations)object2).exec(arg_0 -> GitRepository.hasLocalChanges$lambda$6(GitRepository::hasLocalChanges$lambda$5, arg_0)).getExitValue() != 0;
        return hasUnstagedChanges || hasStagedChanges;
    }

    public final void commitAllChanges(@NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        Project $this$serviceOf$iv = this.project;
        boolean $i$f$serviceOf = false;
        ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
        Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(ExecOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this[T::class.java]");
        ((ExecOperations)object).exec(arg_0 -> GitRepository.commitAllChanges$lambda$8(arg_0 -> GitRepository.commitAllChanges$lambda$7(commitMessage, arg_0), arg_0));
    }

    public final void tag(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Project $this$serviceOf$iv = this.project;
        boolean $i$f$serviceOf = false;
        ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
        Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(ExecOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this[T::class.java]");
        ((ExecOperations)object).exec(arg_0 -> GitRepository.tag$lambda$10(arg_0 -> GitRepository.tag$lambda$9(tagName, arg_0), arg_0));
    }

    private static final Unit getCurrentBranch$lambda$1(ByteArrayOutputStream $stdOut, ExecSpec it) {
        String[] stringArray = new String[]{" "};
        it.setCommandLine(StringsKt.split$default((CharSequence)"git branch --show-current", (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        it.setStandardOutput((OutputStream)$stdOut);
        return Unit.INSTANCE;
    }

    private static final void getCurrentBranch$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit hasLocalChanges$lambda$3(ExecSpec it) {
        String[] stringArray = new String[]{" "};
        it.setCommandLine(StringsKt.split$default((CharSequence)"git diff-files --quiet", (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        it.setIgnoreExitValue(true);
        return Unit.INSTANCE;
    }

    private static final void hasLocalChanges$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit hasLocalChanges$lambda$5(ExecSpec it) {
        String[] stringArray = new String[]{" "};
        it.setCommandLine(StringsKt.split$default((CharSequence)"git diff-index HEAD --quiet", (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        it.setIgnoreExitValue(true);
        return Unit.INSTANCE;
    }

    private static final void hasLocalChanges$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit commitAllChanges$lambda$7(String $commitMessage, ExecSpec it) {
        Object[] objectArray = new String[]{"git", "commit", "-a", "-m", $commitMessage};
        it.setCommandLine(CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final void commitAllChanges$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit tag$lambda$9(String $tagName, ExecSpec it) {
        Object[] objectArray = new String[]{"git", "tag", $tagName};
        it.setCommandLine(CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final void tag$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

