/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.android.release.gradle;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import rocks.frieler.android.release.gradle.GitRepository;
import rocks.frieler.android.release.gradle.ScmChecksKt;
import rocks.frieler.android.release.gradle.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0002R\u001c\u0010\u0004\u001a\u00020\u00058AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lrocks/frieler/android/release/gradle/PerformRelease;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "scmRepository", "Lrocks/frieler/android/release/gradle/GitRepository;", "getScmRepository$android_release_gradle_plugin", "()Lrocks/frieler/android/release/gradle/GitRepository;", "setScmRepository$android_release_gradle_plugin", "(Lrocks/frieler/android/release/gradle/GitRepository;)V", "performRelease", "", "unsnapshotVersion", "", "android-release-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nPerformRelease.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformRelease.kt\nrocks/frieler/android/release/gradle/PerformRelease\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1863#2:56\n1864#2:58\n1#3:57\n*S KotlinDebug\n*F\n+ 1 PerformRelease.kt\nrocks/frieler/android/release/gradle/PerformRelease\n*L\n39#1:56\n39#1:58\n*E\n"})
public class PerformRelease
extends DefaultTask {
    public GitRepository scmRepository;

    public PerformRelease() {
        this.setGroup("versioning");
        this.setDescription("Performs a release by removing the \"-SNAPSHOT\"-suffix from the version name.");
    }

    @Input
    @NotNull
    public final GitRepository getScmRepository$android_release_gradle_plugin() {
        GitRepository gitRepository = this.scmRepository;
        if (gitRepository != null) {
            return gitRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scmRepository");
        return null;
    }

    public final void setScmRepository$android_release_gradle_plugin(@NotNull GitRepository gitRepository) {
        Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"<set-?>");
        this.scmRepository = gitRepository;
    }

    @TaskAction
    public final void performRelease() {
        ScmChecksKt.assertMasterBranch(this.getScmRepository$android_release_gradle_plugin());
        ScmChecksKt.assertNoLocalChanges(this.getScmRepository$android_release_gradle_plugin());
        String releaseVersion = this.unsnapshotVersion();
        this.getScmRepository$android_release_gradle_plugin().commitAllChanges("\"release " + releaseVersion + "\"");
        this.getScmRepository$android_release_gradle_plugin().tag("\"" + releaseVersion + "\"");
    }

    private final String unsnapshotVersion() {
        String releaseVersion = null;
        StringBuilder newGradleFile = new StringBuilder();
        Regex versionSpecificationPattern = new Regex("^\\s*version\\s*=\\s*\"([^\"]*)\"\\s*$");
        File file = this.getProject().file((Object)"./build.gradle.kts");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        Iterable $this$forEach$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder;
            String line = (String)element$iv;
            boolean bl = false;
            MatchResult match = versionSpecificationPattern.matchEntire((CharSequence)line);
            if (match != null) {
                MatchGroup matchGroup = match.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String currentVersion = matchGroup.getValue();
                if (!kotlin.text.StringsKt.endsWith$default((String)currentVersion, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) {
                    boolean bl2 = false;
                    String string = "current version '" + currentVersion + "' is not a SNAPSHOT!";
                    throw new IllegalStateException(string.toString());
                }
                releaseVersion = kotlin.text.StringsKt.replace$default((String)currentVersion, (String)"-SNAPSHOT", (String)"", (boolean)false, (int)4, null);
                String string = match.getValue();
                String string2 = releaseVersion;
                Intrinsics.checkNotNull((Object)string2);
                stringBuilder = StringsKt.appendLineWithSystemEnding(newGradleFile, kotlin.text.StringsKt.replace$default((String)string, (String)currentVersion, (String)string2, (boolean)false, (int)4, null));
                continue;
            }
            stringBuilder = StringsKt.appendLineWithSystemEnding(newGradleFile, line);
        }
        File file2 = this.getProject().file((Object)"./build.gradle.kts");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file(...)");
        String string = newGradleFile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
        if (!(releaseVersion != null)) {
            boolean bl = false;
            String string3 = "no version specification found!";
            throw new IllegalStateException(string3.toString());
        }
        String string4 = releaseVersion;
        Intrinsics.checkNotNull(string4);
        return string4;
    }
}

